/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.impl;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredFileStore;
import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.delegation.server.storage.impl.GenericClientStoreUtils;

public abstract class FSClientStore<V extends Client>
extends MonitoredFileStore<V>
implements ClientStore<V> {
    protected FSClientStore(File storeDirectory, File indexDirectory, IdentifiableProviderImpl<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    public FSClientStore(File f, IdentifiableProviderImpl<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(f, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public MapConverter<V> getMapConverter() {
        return this.converter;
    }

    public void realSave(boolean checkExists, V t) {
        t.setLastModifiedTS((Date)new Timestamp(new Date().getTime()));
        super.realSave(checkExists, t);
    }

    @Override
    public List<Identifier> getByStatus(String status, ClientApprovalStore clientApprovalStore) {
        return GenericClientStoreUtils.getByStatus(this, status, clientApprovalStore);
    }

    @Override
    public List<Identifier> getByApprover(String approver, ClientApprovalStore clientApprovalStore) {
        return GenericClientStoreUtils.getByApprover(this, approver, clientApprovalStore);
    }
}

