/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.upkeep;

import edu.uiuc.ncsa.security.core.cache.MyThread;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.storage.MonitoredStoreInterface;
import edu.uiuc.ncsa.security.storage.monitored.upkeep.UpkeepConfiguration;
import edu.uiuc.ncsa.security.storage.monitored.upkeep.UpkeepResponse;
import java.util.Date;

public class UpkeepThread
extends MyThread {
    AbstractEnvironment environment;
    int counter = -1;
    MonitoredStoreInterface monitoredStore;
    boolean stopThread = false;

    public UpkeepThread(String name, AbstractEnvironment environment, MonitoredStoreInterface store) {
        super(name, environment.getMyLogger());
        this.monitoredStore = store;
        this.environment = environment;
        this.init();
    }

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    protected void init() {
        if (this.getCfg().hasAlarms()) {
            this.setAlarms(this.getCfg().getAlarms());
        } else {
            this.setCleanupInterval(this.getCfg().getInterval());
        }
        this.setTestMode(false);
        this.counter = this.getCfg().getRunCount();
    }

    public boolean isStopThread() {
        return this.stopThread && this.counter == 0;
    }

    public void setStopThread(boolean stopThread) {
        this.stopThread = stopThread;
    }

    protected UpkeepConfiguration getCfg() {
        return this.monitoredStore.getUpkeepConfiguration();
    }

    public void run() {
        this.info("starting " + this.getName());
        while (!this.isStopThread()) {
            try {
                Date nextRun = new Date();
                long nextCleanup = this.getNextSleepInterval();
                if (nextCleanup <= 0L) {
                    this.warn("Thread disabled for " + this.getName() + ". Exiting...");
                    this.setStopThread(true);
                    return;
                }
                nextRun.setTime(nextRun.getTime() + nextCleanup);
                if (0 < this.counter) {
                    --this.counter;
                }
                UpkeepThread.sleep((long)nextCleanup);
                try {
                    UpkeepResponse upkeepResponse = this.monitoredStore.doUpkeep(this.getEnvironment());
                    if (!this.getCfg().isTestOnly()) continue;
                    this.info(this.getName() + " in test mode. Upkeep stats:" + upkeepResponse.report(true));
                }
                catch (Throwable t) {
                    this.info("Upkeep failed (" + t.getClass().getSimpleName() + "):" + t.getMessage());
                }
            }
            catch (InterruptedException e) {
                this.setStopThread(true);
                this.warn("Upkeep for " + this.getName() + " interrupted, stopping thread...");
            }
        }
    }
}

