/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.uuc;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.delegation.server.storage.uuc.MetaRule;
import org.oa4mp.delegation.server.storage.uuc.RuleFilter;

public class ListRule
extends MetaRule {
    boolean blackList = false;
    List<Identifier> idList;
    List<String> regexList;
    RuleFilter ruleFilter;

    public boolean isBlackList() {
        return this.blackList;
    }

    public void setBlackList(boolean blackList) {
        this.blackList = blackList;
    }

    public void setIdList(List<Identifier> idList) {
        this.idList = idList;
    }

    public void setRegexList(List<String> regexList) {
        this.regexList = regexList;
    }

    public List<Identifier> getIDlist() {
        if (this.idList == null) {
            this.idList = new ArrayList<Identifier>();
        }
        return this.idList;
    }

    public List<String> getRegexList() {
        if (this.regexList == null) {
            this.regexList = new ArrayList<String>();
        }
        return this.regexList;
    }

    public RuleFilter getRuleFilter() {
        if (this.ruleFilter == null) {
            this.ruleFilter = new RuleFilter();
        }
        return this.ruleFilter;
    }

    public void setRuleFilter(RuleFilter ruleFilter) {
        this.ruleFilter = ruleFilter;
    }

    public boolean hasRuleFilter() {
        return this.ruleFilter != null;
    }

    public boolean applies(Identifier id) {
        return this.applyToID(id) || this.applyToRegex(id.toString());
    }

    protected boolean applyToID(Identifier id) {
        return this.getIDlist().contains(id);
    }

    protected boolean applyToID(String id) {
        return this.getIDlist().contains(BasicIdentifier.newID((String)id));
    }

    protected boolean applyToRegex(String id) {
        for (String rx : this.getRegexList()) {
            if (!id.matches(rx)) continue;
            return true;
        }
        return false;
    }

    public boolean applies(String id) {
        return this.applyToID(id) || this.applyToRegex(id);
    }
}

