/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.uuc;

import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import org.oa4mp.delegation.server.storage.uuc.DateThingy;

public class RuleFilter {
    public static final String WHEN_AFTER = "after";
    public static final String WHEN_BEFORE = "before";
    public static final String TYPE_ACCESSED = "accessed";
    public static final String TYPE_CREATED = "created";
    public static final String TYPE_MODIFIED = "modified";
    public static final String VERSION_SKIP = "skip";
    public static final String VERSION_ONLY = "only";
    public static final String VERSION_INCLUDE = "include";
    HashMap<String, HashMap<String, DateThingy>> datesByWhen = new HashMap();
    HashMap<String, HashMap<String, DateThingy>> datesByType = new HashMap();
    String version;
    boolean allowOverride = false;

    protected void checkWhen(String w) {
        if (w == null) {
            throw new IllegalArgumentException("missing when parameter");
        }
        switch (w) {
            case "after": 
            case "before": {
                return;
            }
        }
        throw new IllegalArgumentException("unknown when parameter \"" + w + "\"");
    }

    protected void checkType(String t) {
        if (t == null) {
            throw new IllegalArgumentException("missing type parameter");
        }
        switch (t) {
            case "accessed": 
            case "modified": 
            case "created": {
                return;
            }
        }
        throw new IllegalArgumentException("unknown type parameter \"" + t + "\"");
    }

    public HashMap<String, HashMap<String, DateThingy>> getDatesByWhen() {
        return this.datesByWhen;
    }

    public void setDatesByWhen(HashMap<String, HashMap<String, DateThingy>> datesByWhen) {
        this.datesByWhen = datesByWhen;
    }

    public void add(String when, String type, String rawDate) {
        DateThingy dateThingy = null;
        try {
            Calendar calendar = Iso8601.string2Date((String)rawDate);
            dateThingy = new DateThingy(calendar.getTime());
        }
        catch (ParseException e) {
            dateThingy = new DateThingy(XMLConfigUtil.getValueSecsOrMillis((String)rawDate, (boolean)true));
        }
        this.add(when, type, dateThingy);
    }

    protected void addWhen(String when, String type, DateThingy dateThingy) {
        HashMap<String, DateThingy> m = this.datesByWhen.get(when);
        if (m == null) {
            m = new HashMap();
            this.datesByWhen.put(when, m);
        }
        m.put(type, dateThingy);
    }

    protected void addType(String when, String type, DateThingy dateThingy) {
        HashMap<String, DateThingy> m = this.datesByType.get(type);
        if (m == null) {
            m = new HashMap();
            this.datesByType.put(type, m);
        }
        m.put(when, dateThingy);
    }

    public void add(String when, String type, DateThingy dateThingy) {
        this.checkWhen(when);
        this.checkType(type);
        this.addWhen(when, type, dateThingy);
        this.addType(when, type, dateThingy);
    }

    public DateThingy getDate(String when, String type) {
        HashMap<String, DateThingy> m = this.datesByWhen.get(when);
        if (m == null) {
            return null;
        }
        return m.get(type);
    }

    public HashMap<String, DateThingy> getByType(String type) {
        return this.datesByType.get(type);
    }

    public HashMap<String, DateThingy> getByWhen(String when) {
        return this.datesByWhen.get(when);
    }

    public boolean containsByWhen(String when) {
        return this.datesByWhen.containsKey(when);
    }

    public boolean containsByType(String type) {
        return this.datesByType.containsKey(type);
    }

    public boolean hasDate(String when, String type) {
        HashMap<String, DateThingy> m = this.datesByWhen.get(when);
        if (m == null) {
            return false;
        }
        return m.containsKey(type);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        switch (version) {
            case "include": 
            case "only": 
            case "skip": {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version filter \"" + version + "\"");
            }
        }
        this.version = version;
    }

    public boolean isVersion(String v) {
        if (this.version == null) {
            return false;
        }
        return this.version.equals(v);
    }

    public boolean isAllowOverride() {
        return this.allowOverride;
    }

    public void setAllowOverride(boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public RuleFilter overrideFromParent(RuleFilter parent) {
        if (!this.isAllowOverride()) {
            return this;
        }
        RuleFilter rr = null;
        rr = parent.clone();
        if (this.getVersion() != null) {
            rr.setVersion(this.getVersion());
        }
        rr.setAllowOverride(this.isAllowOverride());
        HashMap clonedDates = new HashMap();
        for (String when : this.getDatesByWhen().keySet()) {
            HashMap<String, DateThingy> mm = this.getDatesByWhen().get(when);
            for (String type : mm.keySet()) {
                rr.add(when, type, mm.get(type));
            }
        }
        return rr;
    }

    public boolean apply(long created, long accessed, long modified) {
        return this.checkRule(TYPE_CREATED, created) || this.checkRule(TYPE_ACCESSED, accessed) || this.checkRule(TYPE_MODIFIED, modified);
    }

    protected boolean checkRule(String type, long time) {
        return this.checkRule(this.getByType(type), time);
    }

    protected boolean checkRule(HashMap<String, DateThingy> dd, long time) {
        DateThingy dateThingy;
        if (dd == null) {
            return true;
        }
        boolean applies = true;
        if (dd.containsKey(WHEN_AFTER)) {
            dateThingy = dd.get(WHEN_AFTER);
            if (dateThingy.isRelative()) {
                applies = System.currentTimeMillis() - dateThingy.relativeDate <= time;
            } else {
                boolean bl = applies = dateThingy.iso8601.getTime() <= time;
            }
        }
        if (dd.containsKey(WHEN_BEFORE)) {
            dateThingy = dd.get(WHEN_BEFORE);
            applies = dateThingy.isRelative() ? applies && time <= System.currentTimeMillis() - dateThingy.relativeDate : applies && time <= dateThingy.iso8601.getTime();
        }
        return applies;
    }

    protected RuleFilter clone() {
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setAllowOverride(this.isAllowOverride());
        ruleFilter.setVersion(this.getVersion());
        HashMap<String, HashMap<String, DateThingy>> clonedDates = new HashMap<String, HashMap<String, DateThingy>>();
        for (String key : this.datesByWhen.keySet()) {
            HashMap<String, DateThingy> mm = this.datesByWhen.get(key);
            clonedDates.put(key, (HashMap)mm.clone());
        }
        ruleFilter.setDatesByWhen(clonedDates);
        return ruleFilter;
    }
}

