/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.uuc;

import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import org.oa4mp.delegation.server.storage.uuc.AbandonedRule;
import org.oa4mp.delegation.server.storage.uuc.ListRule;
import org.oa4mp.delegation.server.storage.uuc.MetaRule;
import org.oa4mp.delegation.server.storage.uuc.RuleFilter;
import org.oa4mp.delegation.server.storage.uuc.UnusedRule;

public class UUCConfiguration {
    public static final long UUC_LAST_ACCESSED_NEVER_VALUE = -1L;
    public boolean enabled;
    public long gracePeriod;
    public long interval;
    public boolean testMode = false;
    public Collection<LocalTime> alarms = null;
    public static final int UNUSED_RULE = 100;
    public static final int ABANDONED_RULE = 101;
    public static final int BLACKLIST_RULE = 102;
    public static final int WHITELIST_RULE = 103;
    public static final int[] allRules = new int[]{100, 101, 102, 103};
    public static final String ACTION_TEST = "test";
    public static final String ACTION_ARCHIVE = "archive";
    public static final String ACTION_DELETE = "delete";
    RuleFilter filter = null;
    ListRule blackList;
    ListRule whiteList;
    Boolean lastAccessedNever = null;
    boolean debugOn = false;
    Date createdAfter = null;
    Date createdBefore = null;
    public boolean deleteVersions = false;
    public Long lastAccessedBefore = null;
    public Long lastAccessedAfter = null;
    UnusedRule unusedRule = null;
    AbandonedRule abandonedRule = null;

    public RuleFilter getFilter(int rule) {
        switch (rule) {
            case 100: {
                return this.getUnusedRule().getFilter();
            }
            case 101: {
                return this.getAbandonedRule().getFilter();
            }
            case 103: {
                return this.getWhiteList().getFilter();
            }
            case 102: {
                return this.getBlackList().getFilter();
            }
        }
        return null;
    }

    public boolean hasFilter(int rule) {
        return this.getFilter(rule) != null;
    }

    public boolean hasSubFilter() {
        for (int r : allRules) {
            if (!this.hasFilter(r)) continue;
            return true;
        }
        return false;
    }

    public MetaRule getRule(int rule) {
        switch (rule) {
            case 100: {
                return this.getUnusedRule();
            }
            case 101: {
                return this.getAbandonedRule();
            }
            case 103: {
                return this.getWhiteList();
            }
            case 102: {
                return this.getBlackList();
            }
        }
        return null;
    }

    public boolean hasRule(int rule) {
        switch (rule) {
            case 100: {
                return this.hasUnusedRule();
            }
            case 101: {
                return this.hasAbandonedRule();
            }
            case 103: {
                return this.hasWhitelist();
            }
            case 102: {
                return this.hasBlacklist();
            }
        }
        return false;
    }

    public RuleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RuleFilter filter) {
        this.filter = filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public ListRule getBlackList() {
        return this.blackList;
    }

    public void setBlackList(ListRule blackList) {
        this.blackList = blackList;
    }

    public void setWhiteList(ListRule whiteList) {
        this.whiteList = whiteList;
    }

    public ListRule getWhiteList() {
        return this.whiteList;
    }

    public boolean hasWhitelist() {
        return this.whiteList != null;
    }

    public boolean hasBlacklist() {
        return this.blackList != null;
    }

    public boolean isLastAccessedNever() {
        return this.lastAccessedNever;
    }

    public void setLastAccessedNever(Boolean lastAccessedNever) {
        this.lastAccessedNever = lastAccessedNever;
    }

    boolean hasLastAccessedNever() {
        return this.lastAccessedNever != null;
    }

    public boolean getDebugOn() {
        return this.debugOn;
    }

    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public boolean hasCreatedAfter() {
        return this.createdAfter != null;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public boolean hasCreatedBefore() {
        return this.createdBefore != null;
    }

    public boolean hasAlarms() {
        return this.alarms != null;
    }

    public boolean hasUnusedRule() {
        return this.unusedRule != null;
    }

    public boolean hasAbandonedRule() {
        return this.abandonedRule != null;
    }

    public boolean unusedClientsOnly() {
        return this.lastAccessedBefore == null || this.lastAccessedBefore == -1L;
    }

    public boolean hasLastAccessedAfter() {
        return this.lastAccessedAfter != null;
    }

    public boolean hasLastAccessedBefore() {
        return this.lastAccessedBefore != null;
    }

    public String toString(boolean prettyPrint) {
        if (!prettyPrint) {
            return this.toString();
        }
        return null;
    }

    public UnusedRule getUnusedRule() {
        return this.unusedRule;
    }

    public void setUnusedRule(UnusedRule unusedRule) {
        this.unusedRule = unusedRule;
    }

    public AbandonedRule getAbandonedRule() {
        return this.abandonedRule;
    }

    public void setAbandonedRule(AbandonedRule abandonedRule) {
        this.abandonedRule = abandonedRule;
    }
}

