/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.uuc;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.storage.cli.StoreArchiver;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.oa4mp.delegation.server.storage.uuc.DateThingy;
import org.oa4mp.delegation.server.storage.uuc.UUCConfiguration;

public class UUCRetentionPolicy
implements RetentionPolicy {
    StoreArchiver storeArchiver = null;
    UUCConfiguration config;
    Store store;

    public UUCRetentionPolicy(Store store, UUCConfiguration config) {
        this.config = config;
        this.store = store;
    }

    public StoreArchiver getStoreArchiver() {
        if (this.storeArchiver == null) {
            this.storeArchiver = new StoreArchiver(this.store);
        }
        return this.storeArchiver;
    }

    public int[] retain(Identifier id, Date create, Date lastAccessed, Date lastModified) {
        Long modified;
        Long created = create == null ? null : Long.valueOf(create.getTime());
        Long accessed = lastAccessed == null ? null : Long.valueOf(lastAccessed.getTime());
        Long l = modified = lastModified == null ? null : Long.valueOf(lastModified.getTime());
        if (this.config.hasFilter()) {
            DateThingy dateThingy;
            HashMap<String, DateThingy> createdDates = this.config.getFilter().getByType("created");
            boolean applies = false;
            if (createdDates.containsKey("after")) {
                dateThingy = createdDates.get("after");
                if (dateThingy.isRelative()) {
                    applies = created + dateThingy.relativeDate <= System.currentTimeMillis();
                } else {
                    boolean bl = applies = created <= dateThingy.iso8601.getTime();
                }
            }
            if (createdDates.containsKey("before")) {
                dateThingy = createdDates.get("before");
                if (dateThingy.isRelative()) {
                    applies = applies && System.currentTimeMillis() <= created + dateThingy.relativeDate;
                } else {
                    boolean bl = applies = applies && dateThingy.iso8601.getTime() <= created;
                }
            }
            if (applies) {
                return new int[]{1};
            }
        }
        if (this.config.hasCreatedAfter() && created <= this.config.createdAfter.getTime()) {
            return new int[]{1};
        }
        if (this.config.hasWhitelist() && this.config.getWhiteList().applies(id)) {
            return new int[]{1};
        }
        if (this.config.hasUnusedRule() && this.config.getUnusedRule().applies(created, accessed, modified)) {
            return new int[]{0, 100};
        }
        if (this.config.hasAbandonedRule() && this.config.getAbandonedRule().applies(created, accessed, modified)) {
            return new int[]{0, 101};
        }
        if (this.config.hasBlacklist() && this.config.getBlackList().applies(id)) {
            return new int[]{0, 102};
        }
        return new int[]{1};
    }

    public boolean retain(Object key, Object value) {
        return false;
    }

    public Map getMap() {
        return null;
    }

    public boolean applies() {
        return false;
    }
}

