/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.uuc;

import edu.uiuc.ncsa.security.core.cache.MyThread;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.util.Date;
import org.oa4mp.delegation.server.storage.BaseClientStore;
import org.oa4mp.delegation.server.storage.uuc.UUCConfiguration;

public class UUCThread
extends MyThread {
    UUCConfiguration uucConfiguration;
    BaseClientStore baseClientStore;
    boolean stopThread = false;

    public UUCThread(String name, MyLoggingFacade logger, BaseClientStore clientStore, UUCConfiguration uucConfiguration) {
        super(name, logger);
        this.baseClientStore = clientStore;
        this.uucConfiguration = uucConfiguration;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    public void setStopThread(boolean stopThread) {
        this.stopThread = stopThread;
    }

    public void run() {
        this.info("starting cleanup thread for " + this.getName());
        while (!this.isStopThread()) {
            try {
                Date nextRun = new Date();
                long nextCleanup = this.getNextSleepInterval();
                if (nextCleanup <= 0L) {
                    this.warn("Thread disabled for " + this.getName() + ". Exiting...");
                    this.setStopThread(true);
                    return;
                }
                nextRun.setTime(nextRun.getTime() + nextCleanup);
                UUCThread.sleep((long)nextCleanup);
            }
            catch (InterruptedException e) {
                this.setStopThread(true);
                this.warn("Cleanup for " + this.getName() + " interrupted, stopping thread...");
            }
        }
    }
}

