/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable.catchup;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import org.occurrent.subscription.SubscriptionPosition;
import org.occurrent.time.internal.RFC3339;

public class TimeBasedSubscriptionPosition
implements SubscriptionPosition {
    private static final OffsetDateTime BEGINNING_OF_TIME = Instant.EPOCH.atOffset(ZoneOffset.UTC);
    private final OffsetDateTime time;

    public TimeBasedSubscriptionPosition(OffsetDateTime time) {
        Objects.requireNonNull(time, OffsetDateTime.class.getSimpleName() + " cannot be null");
        this.time = time;
    }

    public static TimeBasedSubscriptionPosition beginningOfTime() {
        return new TimeBasedSubscriptionPosition(BEGINNING_OF_TIME);
    }

    public static TimeBasedSubscriptionPosition from(OffsetDateTime time) {
        return new TimeBasedSubscriptionPosition(time);
    }

    public boolean isBeginningOfTime() {
        return BEGINNING_OF_TIME.equals(this.time);
    }

    public String asString() {
        return RFC3339.RFC_3339_DATE_TIME_FORMATTER.format(this.time);
    }
}

