/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable.catchup;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.function.Predicate;
import org.occurrent.subscription.api.blocking.SubscriptionPositionStorage;
import org.occurrent.subscription.util.predicate.EveryN;

public abstract class SubscriptionPositionStorageConfig {
    private SubscriptionPositionStorageConfig() {
    }

    public static DontUseSubscriptionPositionInStorage dontUseSubscriptionPositionStorage() {
        return new DontUseSubscriptionPositionInStorage();
    }

    public static UseSubscriptionPositionInStorage useSubscriptionPositionStorage(SubscriptionPositionStorage storage) {
        return new UseSubscriptionPositionInStorage(storage);
    }

    public static final class PersistSubscriptionPositionDuringCatchupPhase
    extends UseSubscriptionPositionInStorage {
        public final Predicate<CloudEvent> persistCloudEventPositionPredicate;

        PersistSubscriptionPositionDuringCatchupPhase(SubscriptionPositionStorage storage, Predicate<CloudEvent> persistCloudEventPositionPredicate) {
            super(storage);
            Objects.requireNonNull(persistCloudEventPositionPredicate, "persistCloudEventPositionPredicate cannot be null");
            this.persistCloudEventPositionPredicate = persistCloudEventPositionPredicate;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PersistSubscriptionPositionDuringCatchupPhase)) {
                return false;
            }
            PersistSubscriptionPositionDuringCatchupPhase that = (PersistSubscriptionPositionDuringCatchupPhase)o;
            return Objects.equals(this.storage, that.storage) && Objects.equals(this.persistCloudEventPositionPredicate, that.persistCloudEventPositionPredicate);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.storage, this.persistCloudEventPositionPredicate);
        }

        @Override
        public String toString() {
            return "PersistSubscriptionPositionDuringCatchupPhase{storage=" + this.storage + ", persistCloudEventPositionPredicate=" + this.persistCloudEventPositionPredicate + '}';
        }
    }

    public static class UseSubscriptionPositionInStorage
    extends SubscriptionPositionStorageConfig {
        public final SubscriptionPositionStorage storage;

        UseSubscriptionPositionInStorage(SubscriptionPositionStorage storage) {
            Objects.requireNonNull(storage, SubscriptionPositionStorage.class.getSimpleName() + " cannot be null");
            this.storage = storage;
        }

        public PersistSubscriptionPositionDuringCatchupPhase andPersistSubscriptionPositionDuringCatchupPhaseWhen(Predicate<CloudEvent> persistCloudEventPositionPredicate) {
            return new PersistSubscriptionPositionDuringCatchupPhase(this.storage, persistCloudEventPositionPredicate);
        }

        public PersistSubscriptionPositionDuringCatchupPhase andPersistSubscriptionPositionDuringCatchupPhaseForEveryNEvents(int persistPositionForEveryNCloudEvent) {
            return new PersistSubscriptionPositionDuringCatchupPhase(this.storage, (Predicate<CloudEvent>)EveryN.every((int)persistPositionForEveryNCloudEvent));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UseSubscriptionPositionInStorage)) {
                return false;
            }
            UseSubscriptionPositionInStorage that = (UseSubscriptionPositionInStorage)o;
            return Objects.equals(this.storage, that.storage);
        }

        public int hashCode() {
            return Objects.hash(this.storage);
        }

        public String toString() {
            return "UseSubscriptionPositionInStorage{storage=" + this.storage + '}';
        }
    }

    static final class DontUseSubscriptionPositionInStorage
    extends SubscriptionPositionStorageConfig {
        DontUseSubscriptionPositionInStorage() {
        }
    }
}

