/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable.catchup;

import java.util.Objects;
import org.occurrent.eventstore.api.SortBy;
import org.occurrent.subscription.blocking.durable.catchup.SubscriptionPositionStorageConfig;

public class CatchupSubscriptionModelConfig {
    public final int cacheSize;
    public final SubscriptionPositionStorageConfig subscriptionStorageConfig;
    public final SortBy catchupPhaseSortBy;

    public CatchupSubscriptionModelConfig(int cacheSize) {
        this(cacheSize, SubscriptionPositionStorageConfig.dontUseSubscriptionPositionStorage());
    }

    public CatchupSubscriptionModelConfig(SubscriptionPositionStorageConfig subscriptionStorageConfig) {
        this(100, subscriptionStorageConfig);
    }

    public CatchupSubscriptionModelConfig(int cacheSize, SubscriptionPositionStorageConfig subscriptionStorageConfig) {
        this(cacheSize, subscriptionStorageConfig, (SortBy)SortBy.ascending((String)"time", (String[])new String[]{"streamversion"}));
    }

    private CatchupSubscriptionModelConfig(int cacheSize, SubscriptionPositionStorageConfig subscriptionStorageConfig, SortBy sortBy) {
        if (cacheSize < 1) {
            throw new IllegalArgumentException("Cache size must be greater than or equal to 1");
        }
        Objects.requireNonNull(subscriptionStorageConfig, SubscriptionPositionStorageConfig.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(sortBy, SortBy.class + " cannot be null");
        this.cacheSize = cacheSize;
        this.subscriptionStorageConfig = subscriptionStorageConfig;
        this.catchupPhaseSortBy = sortBy;
    }

    public CatchupSubscriptionModelConfig catchupPhaseSortBy(SortBy sortBy) {
        return new CatchupSubscriptionModelConfig(this.cacheSize, this.subscriptionStorageConfig, sortBy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatchupSubscriptionModelConfig)) {
            return false;
        }
        CatchupSubscriptionModelConfig that = (CatchupSubscriptionModelConfig)o;
        return this.cacheSize == that.cacheSize && Objects.equals(this.subscriptionStorageConfig, that.subscriptionStorageConfig);
    }

    public int hashCode() {
        return Objects.hash(this.cacheSize, this.subscriptionStorageConfig);
    }

    public String toString() {
        return "CatchupSupportingBlockingSubscriptionConfig{cacheSize=" + this.cacheSize + ", catchupPositionPersistenceConfig=" + this.subscriptionStorageConfig + "}";
    }
}

