/*
 *
 *  Copyright 2024 Johan Haleby
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.occurrent.subscription.blocking.durable.catchup;

import java.time.OffsetDateTime;


/**
 * Utility functions for easily specifying start position for the {@link  CatchupSubscriptionModel}.
 * <p>
 * If you're using Kotlin, use the extension functions in {@code org.occurrent.subscription.blocking.durable.catchup.CatchupSubscriptionModelExtensions.kt} file instead.
 * </p>
 */
public class StartAtTime {
    public static org.occurrent.subscription.StartAt beginningOfTime() {
        return org.occurrent.subscription.StartAt.subscriptionPosition(TimeBasedSubscriptionPosition.beginningOfTime());
    }

    public static org.occurrent.subscription.StartAt offsetDateTime(OffsetDateTime offsetDateTime) {
        return org.occurrent.subscription.StartAt.subscriptionPosition(TimeBasedSubscriptionPosition.from(offsetDateTime));
    }
}
