/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable.catchup;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.function.Predicate;
import org.occurrent.subscription.api.blocking.SubscriptionPositionStorage;
import org.occurrent.subscription.util.predicate.EveryN;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SubscriptionPositionStorageConfig {
    public static DontUseSubscriptionPositionInStorage dontUseSubscriptionPositionStorage() {
        return new DontUseSubscriptionPositionInStorage();
    }

    public static UseSubscriptionPositionInStorage useSubscriptionPositionStorage(SubscriptionPositionStorage storage) {
        return new UseOnlySubscriptionPositionInStorage(storage);
    }

    public record DontUseSubscriptionPositionInStorage() implements SubscriptionPositionStorageConfig
    {
    }

    public record UseOnlySubscriptionPositionInStorage(SubscriptionPositionStorage storage) implements UseSubscriptionPositionInStorage
    {
        public UseOnlySubscriptionPositionInStorage {
            Objects.requireNonNull(storage, SubscriptionPositionStorage.class.getSimpleName() + " cannot be null");
        }
    }

    public record PersistSubscriptionPositionDuringCatchupPhase(SubscriptionPositionStorage storage, Predicate<CloudEvent> persistCloudEventPositionPredicate) implements UseSubscriptionPositionInStorage
    {
        public PersistSubscriptionPositionDuringCatchupPhase {
            Objects.requireNonNull(storage, SubscriptionPositionStorage.class.getSimpleName() + " cannot be null");
            Objects.requireNonNull(persistCloudEventPositionPredicate, "persistCloudEventPositionPredicate cannot be null");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UseSubscriptionPositionInStorage
    extends SubscriptionPositionStorageConfig {
        public SubscriptionPositionStorage storage();

        default public PersistSubscriptionPositionDuringCatchupPhase andPersistSubscriptionPositionDuringCatchupPhaseWhen(Predicate<CloudEvent> persistCloudEventPositionPredicate) {
            return new PersistSubscriptionPositionDuringCatchupPhase(this.storage(), persistCloudEventPositionPredicate);
        }

        default public PersistSubscriptionPositionDuringCatchupPhase andPersistSubscriptionPositionDuringCatchupPhaseForEveryNEvents(int persistPositionForEveryNCloudEvent) {
            return new PersistSubscriptionPositionDuringCatchupPhase(this.storage(), (Predicate<CloudEvent>)EveryN.every((int)persistPositionForEveryNCloudEvent));
        }
    }
}

