/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable.catchup;

import java.time.Duration;
import java.util.concurrent.Future;
import org.occurrent.subscription.DurationToTimeoutConverter;
import org.occurrent.subscription.api.blocking.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

record CatchupSubscription(String id, Future<Subscription> delegatedSubscription) implements Subscription
{
    private static final Logger log = LoggerFactory.getLogger(CatchupSubscription.class);

    public boolean waitUntilStarted(Duration timeout) {
        long timeStarted = System.currentTimeMillis();
        DurationToTimeoutConverter.Timeout safeTimeout = DurationToTimeoutConverter.convertDurationToTimeout((Duration)timeout);
        try {
            Subscription subscription = this.delegatedSubscription.get(safeTimeout.timeout(), safeTimeout.timeUnit());
            long catchupEndTime = System.currentTimeMillis();
            long remainingMillisToWait = catchupEndTime - timeStarted;
            Duration remainingDurationToWait = timeout.minusMillis(remainingMillisToWait);
            subscription.waitUntilStarted(remainingDurationToWait);
            return true;
        }
        catch (Exception e) {
            CatchupSubscription.logException(e, Level.WARN);
            return false;
        }
    }

    private static void logException(Exception e, Level level) {
        log.atLevel(level).log("Failed to wait until subscription was started because of exception: {} - {}", new Object[]{e.getClass().getName(), e.getMessage(), e});
    }
}

