/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.converter.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.PojoCloudEventData;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.occurrent.application.converter.CloudEventConverter;

public class JacksonCloudEventConverter<T>
implements CloudEventConverter<T> {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private final ObjectMapper objectMapper;
    private final URI cloudEventSource;
    private final Function<T, String> idMapper;
    private final Function<T, String> typeMapper;
    private final Function<T, OffsetDateTime> timeMapper;
    private final Function<T, String> subjectMapper;
    private final String contentType;

    public JacksonCloudEventConverter(ObjectMapper objectMapper, URI cloudEventSource) {
        this(objectMapper, cloudEventSource, JacksonCloudEventConverter.defaultIdMapperFunction(), JacksonCloudEventConverter.defaultTypeMapperFunction(), JacksonCloudEventConverter.defaultTimeMapperFunction(), JacksonCloudEventConverter.defaultSubjectMapperFunction(), DEFAULT_CONTENT_TYPE);
    }

    private JacksonCloudEventConverter(ObjectMapper objectMapper, URI cloudEventSource, Function<T, String> idMapper, Function<T, String> typeMapper, Function<T, OffsetDateTime> timeMapper, Function<T, String> subjectMapper, String contentType) {
        Objects.requireNonNull(objectMapper, ObjectMapper.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(cloudEventSource, "cloudEventSource cannot be null");
        Objects.requireNonNull(idMapper, "idMapper cannot be null");
        Objects.requireNonNull(typeMapper, "typeMapper cannot be null");
        Objects.requireNonNull(timeMapper, "timeMapper cannot be null");
        Objects.requireNonNull(subjectMapper, "subjectMapper cannot be null");
        this.objectMapper = objectMapper;
        this.cloudEventSource = cloudEventSource;
        this.idMapper = idMapper;
        this.typeMapper = typeMapper;
        this.timeMapper = timeMapper;
        this.subjectMapper = subjectMapper;
        this.contentType = contentType;
    }

    public CloudEvent toCloudEvent(T domainEvent) {
        Objects.requireNonNull(domainEvent, "Domain event cannot be null");
        PojoCloudEventData cloudEventData = PojoCloudEventData.wrap((Object)this.objectMapper.convertValue(domainEvent, (TypeReference)new TypeReference<Map<String, Object>>(){}), arg_0 -> ((ObjectMapper)this.objectMapper).writeValueAsBytes(arg_0));
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(this.idMapper.apply(domainEvent)).withSource(this.cloudEventSource).withType(this.typeMapper.apply(domainEvent)).withTime(this.timeMapper.apply(domainEvent)).withSubject(this.subjectMapper.apply(domainEvent)).withDataContentType(this.contentType).withData((CloudEventData)cloudEventData)).build();
    }

    public T toDomainEvent(CloudEvent cloudEvent) {
        Object domainEvent;
        Class<?> domainEventType;
        CloudEventData data = cloudEvent.getData();
        try {
            domainEventType = Class.forName(cloudEvent.getType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (data instanceof PojoCloudEventData && ((PojoCloudEventData)data).getValue() instanceof Map) {
            Map value = (Map)((PojoCloudEventData)data).getValue();
            domainEvent = this.objectMapper.convertValue((Object)value, domainEventType);
        } else {
            try {
                domainEvent = this.objectMapper.readValue(Objects.requireNonNull(data, "cloud event data cannot be null").toBytes(), domainEventType);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (T)domainEvent;
    }

    private static <T> Function<T, String> defaultIdMapperFunction() {
        return __ -> UUID.randomUUID().toString();
    }

    private static <T> Function<T, String> defaultTypeMapperFunction() {
        return domainEvent -> domainEvent.getClass().getName();
    }

    private static <T> Function<T, OffsetDateTime> defaultTimeMapperFunction() {
        return __ -> OffsetDateTime.now(ZoneOffset.UTC);
    }

    private static <T> Function<T, String> defaultSubjectMapperFunction() {
        return __ -> null;
    }

    static /* synthetic */ Function access$000() {
        return JacksonCloudEventConverter.defaultIdMapperFunction();
    }

    static /* synthetic */ Function access$100() {
        return JacksonCloudEventConverter.defaultTypeMapperFunction();
    }

    static /* synthetic */ Function access$200() {
        return JacksonCloudEventConverter.defaultTimeMapperFunction();
    }

    static /* synthetic */ Function access$300() {
        return JacksonCloudEventConverter.defaultSubjectMapperFunction();
    }

    public static final class Builder<T> {
        private final ObjectMapper objectMapper;
        private final URI cloudEventSource;
        private String contentType = "application/json";
        private Function<T, String> idMapper = JacksonCloudEventConverter.access$000();
        private Function<T, String> typeMapper = JacksonCloudEventConverter.access$100();
        private Function<T, OffsetDateTime> timeMapper = JacksonCloudEventConverter.access$200();
        private Function<T, String> subjectMapper = JacksonCloudEventConverter.access$300();

        public Builder(ObjectMapper objectMapper, URI cloudEventSource) {
            this.objectMapper = objectMapper;
            this.cloudEventSource = cloudEventSource;
        }

        public Builder<T> contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder<T> idMapper(Function<T, String> idMapper) {
            this.idMapper = idMapper;
            return this;
        }

        public Builder<T> typeMapper(Function<T, String> typeMapper) {
            this.typeMapper = typeMapper;
            return this;
        }

        public Builder<T> timeMapper(Function<T, OffsetDateTime> timeMapper) {
            this.timeMapper = timeMapper;
            return this;
        }

        public Builder<T> subjectMapper(Function<T, String> subjectMapper) {
            this.subjectMapper = subjectMapper;
            return this;
        }

        public JacksonCloudEventConverter<T> build() {
            return new JacksonCloudEventConverter(this.objectMapper, this.cloudEventSource, this.idMapper, this.typeMapper, this.timeMapper, this.subjectMapper, this.contentType);
        }
    }
}

