/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.converter.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.PojoCloudEventData;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.occurrent.application.converter.CloudEventConverter;
import org.occurrent.application.converter.typemapper.CloudEventTypeMapper;
import org.occurrent.application.converter.typemapper.ReflectionCloudEventTypeMapper;

public class JacksonCloudEventConverter<T>
implements CloudEventConverter<T> {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private final ObjectMapper objectMapper;
    private final URI cloudEventSource;
    private final Function<T, String> idMapper;
    private final CloudEventTypeMapper<T> cloudEventTypeMapper;
    private final Function<T, OffsetDateTime> timeMapper;
    private final Function<T, String> subjectMapper;
    private final String contentType;

    public JacksonCloudEventConverter(ObjectMapper objectMapper, URI cloudEventSource) {
        this(objectMapper, cloudEventSource, JacksonCloudEventConverter.defaultIdMapperFunction(), JacksonCloudEventConverter.defaultTypeMapper(), JacksonCloudEventConverter.defaultTimeMapperFunction(), JacksonCloudEventConverter.defaultSubjectMapperFunction(), DEFAULT_CONTENT_TYPE);
    }

    private JacksonCloudEventConverter(ObjectMapper objectMapper, URI cloudEventSource, Function<T, String> idMapper, CloudEventTypeMapper<T> cloudEventTypeMapper, Function<T, OffsetDateTime> timeMapper, Function<T, String> subjectMapper, String contentType) {
        Objects.requireNonNull(objectMapper, ObjectMapper.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(cloudEventSource, "cloudEventSource cannot be null");
        Objects.requireNonNull(idMapper, "idMapper cannot be null");
        Objects.requireNonNull(cloudEventTypeMapper, CloudEventTypeMapper.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(timeMapper, "timeMapper cannot be null");
        Objects.requireNonNull(subjectMapper, "subjectMapper cannot be null");
        this.objectMapper = objectMapper;
        this.cloudEventSource = cloudEventSource;
        this.idMapper = idMapper;
        this.timeMapper = timeMapper;
        this.subjectMapper = subjectMapper;
        this.contentType = contentType;
        this.cloudEventTypeMapper = cloudEventTypeMapper;
    }

    public CloudEvent toCloudEvent(T domainEvent) {
        Objects.requireNonNull(domainEvent, "Domain event cannot be null");
        PojoCloudEventData cloudEventData = PojoCloudEventData.wrap((Object)((Map)this.objectMapper.convertValue(domainEvent, (TypeReference)new TypeReference<Map<String, Object>>(){})), arg_0 -> ((ObjectMapper)this.objectMapper).writeValueAsBytes(arg_0));
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(this.idMapper.apply(domainEvent)).withSource(this.cloudEventSource).withType(this.cloudEventTypeMapper.getCloudEventType(domainEvent)).withTime(this.timeMapper.apply(domainEvent)).withSubject(this.subjectMapper.apply(domainEvent)).withDataContentType(this.contentType).withData((CloudEventData)cloudEventData)).build();
    }

    public T toDomainEvent(CloudEvent cloudEvent) {
        Object domainEvent;
        CloudEventData data = cloudEvent.getData();
        Class domainEventType = this.cloudEventTypeMapper.getDomainEventType(cloudEvent.getType());
        if (data instanceof PojoCloudEventData && ((PojoCloudEventData)data).getValue() instanceof Map) {
            Map value = (Map)((PojoCloudEventData)data).getValue();
            domainEvent = this.objectMapper.convertValue((Object)value, domainEventType);
        } else {
            try {
                domainEvent = this.objectMapper.readValue(Objects.requireNonNull(data, "cloud event data cannot be null").toBytes(), domainEventType);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (T)domainEvent;
    }

    public String getCloudEventType(Class<? extends T> type) {
        return this.cloudEventTypeMapper.getCloudEventType(type);
    }

    private static <T> Function<T, String> defaultIdMapperFunction() {
        return __ -> UUID.randomUUID().toString();
    }

    private static <T> CloudEventTypeMapper<T> defaultTypeMapper() {
        return ReflectionCloudEventTypeMapper.qualified();
    }

    private static <T> Function<T, OffsetDateTime> defaultTimeMapperFunction() {
        return __ -> OffsetDateTime.now(ZoneOffset.UTC);
    }

    private static <T> Function<T, String> defaultSubjectMapperFunction() {
        return __ -> null;
    }

    public static final class Builder<T> {
        private final ObjectMapper objectMapper;
        private final URI cloudEventSource;
        private String contentType = "application/json";
        private Function<T, String> idMapper = JacksonCloudEventConverter.defaultIdMapperFunction();
        private CloudEventTypeMapper<T> cloudEventTypeMapper = JacksonCloudEventConverter.defaultTypeMapper();
        private Function<T, OffsetDateTime> timeMapper = JacksonCloudEventConverter.defaultTimeMapperFunction();
        private Function<T, String> subjectMapper = JacksonCloudEventConverter.defaultSubjectMapperFunction();

        public Builder(ObjectMapper objectMapper, URI cloudEventSource) {
            this.objectMapper = objectMapper;
            this.cloudEventSource = cloudEventSource;
        }

        public Builder<T> contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder<T> idMapper(Function<T, String> idMapper) {
            this.idMapper = idMapper;
            return this;
        }

        public Builder<T> typeMapper(CloudEventTypeMapper<T> cloudEventTypeMapper) {
            this.cloudEventTypeMapper = cloudEventTypeMapper;
            return this;
        }

        public Builder<T> timeMapper(Function<T, OffsetDateTime> timeMapper) {
            this.timeMapper = timeMapper;
            return this;
        }

        public Builder<T> subjectMapper(Function<T, String> subjectMapper) {
            this.subjectMapper = subjectMapper;
            return this;
        }

        public JacksonCloudEventConverter<T> build() {
            return new JacksonCloudEventConverter<T>(this.objectMapper, this.cloudEventSource, this.idMapper, this.cloudEventTypeMapper, this.timeMapper, this.subjectMapper, this.contentType);
        }
    }
}

