/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.converter.xstream;

import com.thoughtworks.xstream.XStream;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.occurrent.application.converter.CloudEventConverter;
import org.occurrent.application.converter.typemapper.CloudEventTypeGetter;

public class XStreamCloudEventConverter<T>
implements CloudEventConverter<T> {
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final XStream xStream;
    private final URI cloudEventSource;
    private final Function<T, String> idMapper;
    private final CloudEventTypeGetter<T> cloudEventTypeGetter;
    private final Function<T, OffsetDateTime> timeMapper;
    private final Function<T, String> subjectMapper;
    private final String contentType;
    private final Charset charset;

    public XStreamCloudEventConverter(XStream xStream, URI cloudEventSource) {
        this(xStream, cloudEventSource, XStreamCloudEventConverter.defaultIdMapperFunction(), XStreamCloudEventConverter.defaultCloudEventTypeGetter(), XStreamCloudEventConverter.defaultTimeMapperFunction(), XStreamCloudEventConverter.defaultSubjectMapperFunction(), DEFAULT_CONTENT_TYPE, DEFAULT_CHARSET);
    }

    private XStreamCloudEventConverter(XStream xStream, URI cloudEventSource, Function<T, String> idMapper, CloudEventTypeGetter<T> cloudEventTypeGetter, Function<T, OffsetDateTime> timeMapper, Function<T, String> subjectMapper, String contentType, Charset charset) {
        Objects.requireNonNull(xStream, XStream.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(cloudEventSource, "cloudEventSource cannot be null");
        Objects.requireNonNull(idMapper, "idMapper cannot be null");
        Objects.requireNonNull(cloudEventTypeGetter, "cloudEventTypeGetter cannot be null");
        Objects.requireNonNull(timeMapper, "timeMapper cannot be null");
        Objects.requireNonNull(subjectMapper, "subjectMapper cannot be null");
        Objects.requireNonNull(charset, Charset.class.getSimpleName() + " cannot be null");
        this.xStream = xStream;
        this.cloudEventSource = cloudEventSource;
        this.idMapper = idMapper;
        this.timeMapper = timeMapper;
        this.subjectMapper = subjectMapper;
        this.contentType = contentType;
        this.charset = charset;
        this.cloudEventTypeGetter = cloudEventTypeGetter;
    }

    public CloudEvent toCloudEvent(T domainEvent) {
        Objects.requireNonNull(domainEvent, "Domain event cannot be null");
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(this.idMapper.apply(domainEvent)).withSource(this.cloudEventSource).withType(this.cloudEventTypeGetter.getCloudEventType(domainEvent)).withTime(this.timeMapper.apply(domainEvent)).withSubject(this.subjectMapper.apply(domainEvent)).withDataContentType(this.contentType).withData(this.xStream.toXML(domainEvent).getBytes(this.charset))).build();
    }

    public T toDomainEvent(CloudEvent cloudEvent) {
        return (T)this.xStream.fromXML(new String(Objects.requireNonNull(cloudEvent.getData()).toBytes(), this.charset));
    }

    public String getCloudEventType(Class<? extends T> type) {
        return this.cloudEventTypeGetter.getCloudEventType(type);
    }

    private static <T> Function<T, String> defaultIdMapperFunction() {
        return __ -> UUID.randomUUID().toString();
    }

    private static <T> CloudEventTypeGetter<T> defaultCloudEventTypeGetter() {
        return Class::getSimpleName;
    }

    private static <T> Function<T, OffsetDateTime> defaultTimeMapperFunction() {
        return __ -> OffsetDateTime.now(ZoneOffset.UTC);
    }

    private static <T> Function<T, String> defaultSubjectMapperFunction() {
        return __ -> null;
    }

    static /* synthetic */ Charset access$000() {
        return DEFAULT_CHARSET;
    }

    static /* synthetic */ Function access$100() {
        return XStreamCloudEventConverter.defaultIdMapperFunction();
    }

    static /* synthetic */ CloudEventTypeGetter access$200() {
        return XStreamCloudEventConverter.defaultCloudEventTypeGetter();
    }

    static /* synthetic */ Function access$300() {
        return XStreamCloudEventConverter.defaultTimeMapperFunction();
    }

    static /* synthetic */ Function access$400() {
        return XStreamCloudEventConverter.defaultSubjectMapperFunction();
    }

    public static final class Builder<T> {
        private final XStream xStream;
        private final URI cloudEventSource;
        private String contentType = "application/xml";
        private Charset charset = XStreamCloudEventConverter.access$000();
        private Function<T, String> idMapper = XStreamCloudEventConverter.access$100();
        private CloudEventTypeGetter<T> cloudEventTypeGetter = XStreamCloudEventConverter.access$200();
        private Function<T, OffsetDateTime> timeMapper = XStreamCloudEventConverter.access$300();
        private Function<T, String> subjectMapper = XStreamCloudEventConverter.access$400();

        public Builder(XStream xStream, URI cloudEventSource) {
            this.xStream = xStream;
            this.cloudEventSource = cloudEventSource;
        }

        public Builder<T> contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder<T> idMapper(Function<T, String> idMapper) {
            this.idMapper = idMapper;
            return this;
        }

        public Builder<T> typeGetter(CloudEventTypeGetter<T> cloudEventTypeGetter) {
            this.cloudEventTypeGetter = cloudEventTypeGetter;
            return this;
        }

        public Builder<T> timeMapper(Function<T, OffsetDateTime> timeMapper) {
            this.timeMapper = timeMapper;
            return this;
        }

        public Builder<T> subjectMapper(Function<T, String> subjectMapper) {
            this.subjectMapper = subjectMapper;
            return this;
        }

        public Builder<T> charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public XStreamCloudEventConverter<T> build() {
            return new XStreamCloudEventConverter(this.xStream, this.cloudEventSource, this.idMapper, this.cloudEventTypeGetter, this.timeMapper, this.subjectMapper, this.contentType, this.charset);
        }
    }
}

