/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.composition.command.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class SequentialFunctionComposer<T> {
    private final List<Function<List<T>, List<T>>> functions;

    public SequentialFunctionComposer(List<Function<List<T>, List<T>>> functions) {
        this.functions = functions;
    }

    public Function<List<T>, List<T>> compose() {
        return initialEvents -> {
            State resultingState = this.functions.stream().collect(() -> new State(initialEvents), (state, fn) -> {
                List newEvents = (List)fn.apply(state.allEvents());
                state.addAll(newEvents);
            }, (state1, state2) -> {});
            return resultingState.accumulatedEvents;
        };
    }

    private static class State<T> {
        private final List<T> initialEvents;
        private final List<T> accumulatedEvents;

        private State(List<T> initialEvents) {
            this.initialEvents = initialEvents;
            this.accumulatedEvents = new ArrayList<T>();
        }

        private void addAll(List<T> events) {
            this.accumulatedEvents.addAll(events);
        }

        private List<T> allEvents() {
            ArrayList<T> eventList = new ArrayList<T>(this.initialEvents);
            eventList.addAll(this.accumulatedEvents);
            return Collections.unmodifiableList(eventList);
        }
    }
}

