/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable;

import io.cloudevents.CloudEvent;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.occurrent.subscription.PositionAwareCloudEvent;
import org.occurrent.subscription.StartAt;
import org.occurrent.subscription.SubscriptionFilter;
import org.occurrent.subscription.SubscriptionPosition;
import org.occurrent.subscription.api.blocking.DelegatingSubscriptionModel;
import org.occurrent.subscription.api.blocking.PositionAwareSubscriptionModel;
import org.occurrent.subscription.api.blocking.Subscription;
import org.occurrent.subscription.api.blocking.SubscriptionPositionStorage;
import org.occurrent.subscription.blocking.durable.DurableSubscriptionModelConfig;
import org.occurrent.subscription.util.predicate.EveryN;

public class DurableSubscriptionModel
implements PositionAwareSubscriptionModel,
DelegatingSubscriptionModel {
    private final PositionAwareSubscriptionModel subscriptionModel;
    private final SubscriptionPositionStorage storage;
    private final DurableSubscriptionModelConfig config;

    public DurableSubscriptionModel(PositionAwareSubscriptionModel subscriptionModel, SubscriptionPositionStorage storage) {
        this(subscriptionModel, storage, new DurableSubscriptionModelConfig((Predicate<CloudEvent>)EveryN.everyEvent()));
    }

    public DurableSubscriptionModel(PositionAwareSubscriptionModel subscriptionModel, SubscriptionPositionStorage storage, DurableSubscriptionModelConfig config) {
        Objects.requireNonNull(subscriptionModel, "subscription cannot be null");
        Objects.requireNonNull(storage, SubscriptionPositionStorage.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(config, DurableSubscriptionModelConfig.class.getSimpleName() + " cannot be null");
        this.storage = storage;
        this.subscriptionModel = subscriptionModel;
        this.config = config;
    }

    public Subscription subscribe(String subscriptionId, SubscriptionFilter filter, StartAt startAt, Consumer<CloudEvent> action) {
        Objects.requireNonNull(startAt, StartAt.class.getSimpleName() + " supplier cannot be null");
        StartAt startAtToUse = startAt.isDefault() ? StartAt.dynamic(() -> {
            SubscriptionPosition globalSubscriptionPosition;
            SubscriptionPosition subscriptionPosition = this.storage.read(subscriptionId);
            if (subscriptionPosition == null && (globalSubscriptionPosition = this.subscriptionModel.globalSubscriptionPosition()) != null) {
                subscriptionPosition = this.storage.save(subscriptionId, globalSubscriptionPosition);
            }
            return subscriptionPosition == null ? StartAt.subscriptionModelDefault() : StartAt.subscriptionPosition((SubscriptionPosition)subscriptionPosition);
        }) : startAt;
        return this.subscriptionModel.subscribe(subscriptionId, filter, startAtToUse, cloudEvent -> {
            action.accept((CloudEvent)cloudEvent);
            if (this.config.persistCloudEventPositionPredicate.test((CloudEvent)cloudEvent)) {
                SubscriptionPosition subscriptionPosition = PositionAwareCloudEvent.getSubscriptionPositionOrThrowIAE((CloudEvent)cloudEvent);
                this.storage.save(subscriptionId, subscriptionPosition);
            }
        });
    }

    public void stop() {
        this.getDelegatedSubscriptionModel().stop();
    }

    public void start() {
        this.getDelegatedSubscriptionModel().start();
    }

    public boolean isRunning() {
        return this.getDelegatedSubscriptionModel().isRunning();
    }

    public boolean isRunning(String subscriptionId) {
        return this.getDelegatedSubscriptionModel().isRunning(subscriptionId);
    }

    public boolean isPaused(String subscriptionId) {
        return this.getDelegatedSubscriptionModel().isPaused(subscriptionId);
    }

    public Subscription resumeSubscription(String subscriptionId) {
        return this.getDelegatedSubscriptionModel().resumeSubscription(subscriptionId);
    }

    public void pauseSubscription(String subscriptionId) {
        this.getDelegatedSubscriptionModel().pauseSubscription(subscriptionId);
    }

    public void cancelSubscription(String subscriptionId) {
        this.subscriptionModel.cancelSubscription(subscriptionId);
        this.storage.delete(subscriptionId);
    }

    @PreDestroy
    public void shutdown() {
        this.subscriptionModel.shutdown();
    }

    public SubscriptionPosition globalSubscriptionPosition() {
        return this.subscriptionModel.globalSubscriptionPosition();
    }

    public PositionAwareSubscriptionModel getDelegatedSubscriptionModel() {
        return this.subscriptionModel;
    }
}

