/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.blocking.durable;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.occurrent.subscription.PositionAwareCloudEvent;
import org.occurrent.subscription.StartAt;
import org.occurrent.subscription.SubscriptionFilter;
import org.occurrent.subscription.SubscriptionPosition;
import org.occurrent.subscription.api.blocking.PositionAwareSubscriptionModel;
import org.occurrent.subscription.api.blocking.Subscription;
import org.occurrent.subscription.api.blocking.SubscriptionPositionStorage;
import org.occurrent.subscription.blocking.durable.DurableSubscriptionModelConfig;
import org.occurrent.subscription.util.predicate.EveryN;

public class DurableSubscriptionModel
implements PositionAwareSubscriptionModel {
    private final PositionAwareSubscriptionModel subscription;
    private final SubscriptionPositionStorage storage;
    private final DurableSubscriptionModelConfig config;

    public DurableSubscriptionModel(PositionAwareSubscriptionModel subscription, SubscriptionPositionStorage storage) {
        this(subscription, storage, new DurableSubscriptionModelConfig((Predicate<CloudEvent>)EveryN.everyEvent()));
    }

    public DurableSubscriptionModel(PositionAwareSubscriptionModel subscription, SubscriptionPositionStorage storage, DurableSubscriptionModelConfig config) {
        Objects.requireNonNull(subscription, "subscription cannot be null");
        Objects.requireNonNull(storage, SubscriptionPositionStorage.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(config, DurableSubscriptionModelConfig.class.getSimpleName() + " cannot be null");
        this.storage = storage;
        this.subscription = subscription;
        this.config = config;
    }

    public Subscription subscribe(String subscriptionId, SubscriptionFilter filter, Supplier<StartAt> startAtSupplier, Consumer<CloudEvent> action) {
        return this.subscription.subscribe(subscriptionId, filter, startAtSupplier, cloudEvent -> {
            action.accept((CloudEvent)cloudEvent);
            if (this.config.persistCloudEventPositionPredicate.test((CloudEvent)cloudEvent)) {
                SubscriptionPosition subscriptionPosition = PositionAwareCloudEvent.getSubscriptionPositionOrThrowIAE((CloudEvent)cloudEvent);
                this.storage.save(subscriptionId, subscriptionPosition);
            }
        });
    }

    public Subscription subscribe(String subscriptionId, Consumer<CloudEvent> action) {
        return this.subscribe(subscriptionId, null, action);
    }

    public Subscription subscribe(String subscriptionId, SubscriptionFilter filter, Consumer<CloudEvent> action) {
        Supplier<StartAt> startAtSupplier = () -> {
            SubscriptionPosition subscriptionPosition = this.storage.read(subscriptionId);
            if (subscriptionPosition == null) {
                subscriptionPosition = this.storage.save(subscriptionId, this.subscription.globalSubscriptionPosition());
            }
            return StartAt.subscriptionPosition((SubscriptionPosition)subscriptionPosition);
        };
        return this.subscribe(subscriptionId, filter, startAtSupplier, action);
    }

    public void pauseSubscription(String subscriptionId) {
        this.subscription.cancelSubscription(subscriptionId);
    }

    public void cancelSubscription(String subscriptionId) {
        this.pauseSubscription(subscriptionId);
        this.storage.delete(subscriptionId);
    }

    @PreDestroy
    public void shutdownSubscribers() {
        this.subscription.shutdown();
    }

    public SubscriptionPosition globalSubscriptionPosition() {
        return this.subscription.globalSubscriptionPosition();
    }
}

