/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorShutdown {
    public static void shutdownSafely(ExecutorService executorService, long timeout, TimeUnit unit) {
        if (!executorService.isShutdown() && !executorService.isTerminated()) {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(timeout, unit)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!executorService.isTerminated()) {
                    executorService.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }
    }
}

