/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.occurrent.subscription.SubscriptionPosition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StartAt {
    public StartAt get();

    default public boolean isNow() {
        return this instanceof Now;
    }

    default public boolean isDefault() {
        return this instanceof Default;
    }

    public static Now now() {
        return new Now();
    }

    public static Default subscriptionModelDefault() {
        return new Default();
    }

    public static StartAt subscriptionPosition(SubscriptionPosition subscriptionPosition) {
        return new StartAtSubscriptionPosition(subscriptionPosition);
    }

    public static StartAt dynamic(Supplier<StartAt> supplier) {
        return new Dynamic(supplier);
    }

    public static final class Now
    implements StartAt {
        private Now() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public StartAt get() {
            return this;
        }
    }

    public static final class Default
    implements StartAt {
        private Default() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public StartAt get() {
            return this;
        }
    }

    public static final class StartAtSubscriptionPosition
    implements StartAt {
        public final SubscriptionPosition subscriptionPosition;

        private StartAtSubscriptionPosition(SubscriptionPosition subscriptionPosition) {
            Objects.requireNonNull(subscriptionPosition, SubscriptionPosition.class.getSimpleName() + " cannot be null");
            this.subscriptionPosition = subscriptionPosition;
        }

        public String toString() {
            return this.subscriptionPosition.asString();
        }

        @Override
        public StartAt get() {
            return this;
        }
    }

    public static final class Dynamic
    implements StartAt {
        public final Supplier<StartAt> supplier;

        private Dynamic(Supplier<StartAt> supplier) {
            Objects.requireNonNull(supplier, "StartAt supplier cannot be null");
            this.supplier = supplier;
        }

        public String toString() {
            return new StringJoiner(", ", Dynamic.class.getSimpleName() + "[", "]").add("supplier=" + this.supplier).toString();
        }

        @Override
        public StartAt get() {
            StartAt startAt = this.supplier.get();
            if (startAt instanceof Dynamic) {
                return startAt.get();
            }
            if (startAt == null) {
                throw new IllegalArgumentException("Dynamic \"start at\" was null which is not supported.");
            }
            return startAt;
        }
    }
}

