/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DurationToTimeoutConverter {
    public static Timeout convertDurationToTimeout(Duration duration) {
        TimeUnit timeUnit;
        long timeout;
        if (duration.isNegative()) {
            return new Timeout(0L, TimeUnit.MILLISECONDS);
        }
        if (duration.equals(ChronoUnit.FOREVER.getDuration())) {
            timeout = Long.MAX_VALUE;
            timeUnit = TimeUnit.DAYS;
        } else if (DurationToTimeoutConverter.checkDurationSafely(() -> duration.toMillis() < TimeUnit.SECONDS.toMillis(1L))) {
            timeout = duration.toMillis();
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (DurationToTimeoutConverter.checkDurationSafely(() -> duration.toSeconds() < TimeUnit.MINUTES.toSeconds(1L))) {
            timeout = duration.getSeconds();
            timeUnit = TimeUnit.SECONDS;
        } else if (DurationToTimeoutConverter.checkDurationSafely(() -> duration.toMinutes() < TimeUnit.HOURS.toMinutes(1L))) {
            timeout = duration.toMinutes();
            timeUnit = TimeUnit.MINUTES;
        } else if (DurationToTimeoutConverter.checkDurationSafely(() -> duration.toHours() < TimeUnit.DAYS.toHours(1L))) {
            timeout = duration.toHours();
            timeUnit = TimeUnit.HOURS;
        } else {
            timeout = duration.toDays();
            timeUnit = TimeUnit.DAYS;
        }
        return new Timeout(timeout, timeUnit);
    }

    private static boolean checkDurationSafely(Supplier<Boolean> check) {
        try {
            return check.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Timeout convertDurationToTimeout(Duration duration, TimeUnit timeUnit) {
        long timeout;
        if (duration.isNegative()) {
            return new Timeout(0L, timeUnit);
        }
        Timeout durationTimeout = DurationToTimeoutConverter.getDurationAsTimeout(duration);
        try {
            timeout = timeUnit.convert(durationTimeout.timeout, durationTimeout.timeUnit);
        }
        catch (ArithmeticException ex) {
            timeout = switch (timeUnit) {
                default -> throw new IncompatibleClassChangeError();
                case TimeUnit.NANOSECONDS -> Long.MAX_VALUE;
                case TimeUnit.MICROSECONDS -> 9223372036854775L;
                case TimeUnit.MILLISECONDS -> 9223372036854L;
                case TimeUnit.SECONDS -> 9223372036L;
                case TimeUnit.MINUTES -> 153722867L;
                case TimeUnit.HOURS -> 2562047L;
                case TimeUnit.DAYS -> 106751L;
            };
        }
        return new Timeout(timeout, timeUnit);
    }

    public static Timeout getDurationAsTimeout(Duration duration) {
        try {
            long nanos = duration.toNanos();
            if (nanos < 1000L) {
                return new Timeout(nanos, TimeUnit.NANOSECONDS);
            }
            if (nanos < 1000000L) {
                return new Timeout(duration.toMillis() * 1000L + (long)(duration.getNano() / 1000), TimeUnit.MICROSECONDS);
            }
            if (nanos < 1000000000L) {
                return new Timeout(duration.toMillis(), TimeUnit.MILLISECONDS);
            }
            return DurationToTimeoutConverter.getTimeoutFromDurationSeconds(duration);
        }
        catch (ArithmeticException ex) {
            return DurationToTimeoutConverter.getTimeoutFromDurationSeconds(duration);
        }
    }

    private static Timeout getTimeoutFromDurationSeconds(Duration duration) {
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return new Timeout(seconds, TimeUnit.SECONDS);
        }
        if (seconds < 3600L) {
            return new Timeout(duration.toMinutes(), TimeUnit.MINUTES);
        }
        if (seconds < 86400L) {
            return new Timeout(duration.toHours(), TimeUnit.HOURS);
        }
        return new Timeout(duration.toDays(), TimeUnit.DAYS);
    }

    public record Timeout(long timeout, TimeUnit timeUnit) {
    }
}

