/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import org.occurrent.subscription.SubscriptionPosition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StartAt {
    public StartAt get(SubscriptionModelContext var1);

    default public boolean isNow() {
        return this instanceof Now;
    }

    default public boolean isDefault() {
        return this instanceof Default;
    }

    default public boolean isDynamic() {
        return this instanceof Dynamic;
    }

    public static Now now() {
        return new Now();
    }

    public static Default subscriptionModelDefault() {
        return new Default();
    }

    public static StartAt subscriptionPosition(SubscriptionPosition subscriptionPosition) {
        return new StartAtSubscriptionPosition(subscriptionPosition);
    }

    public static StartAt dynamic(Supplier<StartAt> supplier) {
        return new Dynamic(__ -> (StartAt)supplier.get());
    }

    public static StartAt dynamic(Function<SubscriptionModelContext, StartAt> supplier) {
        return new Dynamic(supplier);
    }

    public static final class Now
    implements StartAt {
        private Now() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public StartAt get(SubscriptionModelContext ignored) {
            return this;
        }
    }

    public static final class Default
    implements StartAt {
        private Default() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public StartAt get(SubscriptionModelContext ignored) {
            return this;
        }
    }

    public static final class Dynamic
    implements StartAt {
        public final Function<SubscriptionModelContext, StartAt> function;

        private Dynamic(Function<SubscriptionModelContext, StartAt> function) {
            Objects.requireNonNull(function, "Dynamic StartAt function cannot be null");
            this.function = function;
        }

        public String toString() {
            return new StringJoiner(", ", Dynamic.class.getSimpleName() + "[", "]").add("supplier=" + this.function).toString();
        }

        @Override
        public StartAt get(SubscriptionModelContext context) {
            StartAt startAt = this.function.apply(context);
            if (startAt instanceof Dynamic) {
                return startAt.get(context);
            }
            return startAt;
        }
    }

    public static final class StartAtSubscriptionPosition
    implements StartAt {
        public final SubscriptionPosition subscriptionPosition;

        private StartAtSubscriptionPosition(SubscriptionPosition subscriptionPosition) {
            Objects.requireNonNull(subscriptionPosition, SubscriptionPosition.class.getSimpleName() + " cannot be null");
            this.subscriptionPosition = subscriptionPosition;
        }

        public String toString() {
            return this.subscriptionPosition.asString();
        }

        @Override
        public StartAt get(SubscriptionModelContext ignored) {
            return this;
        }
    }

    public record SubscriptionModelContext(Class<?> subscriptionModelType) {
        public SubscriptionModelContext {
            Objects.requireNonNull(subscriptionModelType, "subscriptionModelType cannot be null");
        }

        public boolean hasSubscriptionModelType(Class<?> subscriptionModelType) {
            return Objects.equals(this.subscriptionModelType, subscriptionModelType);
        }
    }
}

