/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.lang.Nullable;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.occurrent.subscription.SubscriptionPosition;

public final class PositionAwareCloudEvent
implements CloudEvent {
    private final CloudEvent cloudEvent;
    private final SubscriptionPosition subscriptionPosition;

    public PositionAwareCloudEvent(CloudEvent cloudEvent, SubscriptionPosition subscriptionPosition) {
        Objects.requireNonNull(cloudEvent, CloudEvent.class.getSimpleName() + "cannot be null");
        Objects.requireNonNull(subscriptionPosition, SubscriptionPosition.class.getSimpleName() + "cannot be null");
        this.cloudEvent = cloudEvent;
        this.subscriptionPosition = subscriptionPosition;
    }

    @Nullable
    public CloudEventData getData() {
        return this.cloudEvent.getData();
    }

    public SpecVersion getSpecVersion() {
        return this.cloudEvent.getSpecVersion();
    }

    public String getId() {
        return this.cloudEvent.getId();
    }

    public String getType() {
        return this.cloudEvent.getType();
    }

    public URI getSource() {
        return this.cloudEvent.getSource();
    }

    @Nullable
    public String getDataContentType() {
        return this.cloudEvent.getDataContentType();
    }

    @Nullable
    public URI getDataSchema() {
        return this.cloudEvent.getDataSchema();
    }

    @Nullable
    public String getSubject() {
        return this.cloudEvent.getSubject();
    }

    @Nullable
    public OffsetDateTime getTime() {
        return this.cloudEvent.getTime();
    }

    @Nullable
    public Object getAttribute(String attributeName) throws IllegalArgumentException {
        return this.cloudEvent.getAttribute(attributeName);
    }

    public Set<String> getAttributeNames() {
        return this.cloudEvent.getAttributeNames();
    }

    @Nullable
    public Object getExtension(String extensionName) {
        return this.cloudEvent.getExtension(extensionName);
    }

    public Set<String> getExtensionNames() {
        return this.cloudEvent.getExtensionNames();
    }

    public SubscriptionPosition getSubscriptionPosition() {
        return this.subscriptionPosition;
    }

    public CloudEvent getOriginalCloudEvent() {
        return this.cloudEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PositionAwareCloudEvent)) {
            return false;
        }
        PositionAwareCloudEvent that = (PositionAwareCloudEvent)o;
        return Objects.equals(this.cloudEvent, that.cloudEvent) && Objects.equals(this.subscriptionPosition, that.subscriptionPosition);
    }

    public int hashCode() {
        return Objects.hash(this.cloudEvent, this.subscriptionPosition);
    }

    public String toString() {
        return "SubscriptionCloudEvent{cloudEvent=" + this.cloudEvent + ", changeStreamPosition=" + this.subscriptionPosition + '}';
    }

    public static boolean hasSubscriptionPosition(CloudEvent cloudEvent) {
        return cloudEvent instanceof PositionAwareCloudEvent;
    }

    public static SubscriptionPosition getSubscriptionPositionOrThrowIAE(CloudEvent cloudEvent) {
        return PositionAwareCloudEvent.getSubscriptionPosition(cloudEvent).orElseThrow(() -> new IllegalArgumentException(CloudEvent.class.getSimpleName() + " doesn't contain a subscription position"));
    }

    public static Optional<SubscriptionPosition> getSubscriptionPosition(CloudEvent cloudEvent) {
        if (cloudEvent instanceof PositionAwareCloudEvent) {
            return Optional.ofNullable(((PositionAwareCloudEvent)cloudEvent).getSubscriptionPosition());
        }
        return Optional.empty();
    }
}

