/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.testsupport.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Objects;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class FlushMongoDBExtension
implements BeforeEachCallback {
    private final ConnectionString connectionString;

    public FlushMongoDBExtension(ConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        try {
            this.flushDb(0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void flushDb(int attempt) throws InterruptedException {
        block14: {
            String databaseName = Objects.requireNonNull(this.connectionString.getDatabase(), "Database cannot be null in MongoDB connection string");
            try (MongoClient mongoClient = MongoClients.create((ConnectionString)this.connectionString);){
                mongoClient.getDatabase(databaseName).drop();
            }
            catch (Throwable t) {
                System.out.println("Failed to flush database:" + t);
                Thread.sleep(100L);
                if (attempt >= 10) break block14;
                this.flushDb(attempt + 1);
            }
        }
    }
}

