/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.domain;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.occurrent.command.ChangeName;
import org.occurrent.command.DefineName;
import org.occurrent.domain.DomainEvent;
import org.occurrent.domain.NameDefined;
import org.occurrent.domain.NameWasChanged;
import org.occurrent.time.TimeConversion;

public class Name {
    public static List<DomainEvent> defineNameFromCommand(List<DomainEvent> events, DefineName defineName) {
        return Name.defineName(events, UUID.randomUUID().toString(), defineName.getTime(), defineName.getName());
    }

    public static List<DomainEvent> defineName(List<DomainEvent> events, String eventId, LocalDateTime time, String name) {
        if (!events.isEmpty()) {
            throw new IllegalStateException("No previous events can exist when defining a name");
        }
        return Name.defineTheName(eventId, time, name);
    }

    public static List<DomainEvent> defineTheName(String eventId, LocalDateTime time, String name) {
        return Collections.singletonList(new NameDefined(eventId, TimeConversion.toDate(time), name));
    }

    public static List<DomainEvent> changeNameFromCommand(List<DomainEvent> events, ChangeName changeName) {
        return Name.changeName(events, UUID.randomUUID().toString(), changeName.getTime(), changeName.getNewName());
    }

    public static List<DomainEvent> changeName(List<DomainEvent> events, String eventId, LocalDateTime time, String newName) {
        Predicate<DomainEvent> isInstanceOfNameDefined = NameDefined.class::isInstance;
        Predicate<DomainEvent> isInstanceOfNameWasChanged = NameWasChanged.class::isInstance;
        String currentName = events.stream().filter(isInstanceOfNameDefined.or(isInstanceOfNameWasChanged)).reduce("", (__, e) -> e instanceof NameDefined ? e.getName() : e.getName(), (name1, name2) -> name2);
        if (Objects.equals(currentName, "John Doe")) {
            throw new IllegalArgumentException("Cannot change name from John Doe since this is the ultimate name");
        }
        if (currentName.isEmpty()) {
            throw new IllegalArgumentException("Cannot change name this it is currently undefined");
        }
        return Collections.singletonList(new NameWasChanged(eventId, TimeConversion.toDate(time), newName));
    }
}

