/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.testsupport.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Objects;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class FlushMongoDBExtension
implements BeforeEachCallback {
    private final ConnectionString connectionString;

    public FlushMongoDBExtension(ConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        String databaseName = Objects.requireNonNull(this.connectionString.getDatabase(), "Database cannot be null in MongoDB connection string");
        try (MongoClient mongoClient = MongoClients.create((ConnectionString)this.connectionString);){
            mongoClient.getDatabase(databaseName).drop();
        }
    }
}

