/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.domain;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import org.occurrent.domain.DomainEvent;
import org.occurrent.time.TimeConversion;

public class NameWasChanged
implements DomainEvent {
    private String eventId;
    private Date timestamp;
    private String name;

    NameWasChanged() {
    }

    public NameWasChanged(String eventId, Date timestamp, String nameChangedTo) {
        this.eventId = eventId;
        this.timestamp = timestamp;
        this.name = nameChangedTo;
    }

    public NameWasChanged(String eventId, LocalDateTime timestamp, String name) {
        this(eventId, TimeConversion.toDate(timestamp), name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NameWasChanged)) {
            return false;
        }
        NameWasChanged that = (NameWasChanged)o;
        return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.timestamp, this.name);
    }

    public String toString() {
        return "NameWasChanged{id='" + this.eventId + '\'' + ", timestamp=" + this.timestamp + ", name='" + this.name + '\'' + '}';
    }
}

