/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.logging.jboss;

import org.ocpsoft.logging.Logger;

public class JBossLoggingLogAdapter
extends Logger {
    private final org.jboss.logging.Logger delegate;

    public JBossLoggingLogAdapter(String name) {
        this.delegate = org.jboss.logging.Logger.getLogger((String)name);
    }

    protected void log(Logger.Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                if (t == null) {
                    this.delegate.trace((Object)msg);
                    break;
                }
                this.delegate.trace((Object)msg, t);
                break;
            }
            case DEBUG: {
                if (t == null) {
                    this.delegate.debug((Object)msg);
                    break;
                }
                this.delegate.debug((Object)msg, t);
                break;
            }
            case INFO: {
                if (t == null) {
                    this.delegate.info((Object)msg);
                    break;
                }
                this.delegate.info((Object)msg, t);
                break;
            }
            case WARN: {
                if (t == null) {
                    this.delegate.warn((Object)msg);
                    break;
                }
                this.delegate.warn((Object)msg, t);
                break;
            }
            case ERROR: {
                if (t == null) {
                    this.delegate.error((Object)msg);
                    break;
                }
                this.delegate.error((Object)msg, t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle log leve: " + level);
            }
        }
    }

    protected boolean isEnabled(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return this.delegate.isTraceEnabled();
            }
            case DEBUG: {
                return this.delegate.isDebugEnabled();
            }
            case INFO: {
                return this.delegate.isInfoEnabled();
            }
            case WARN: {
                return true;
            }
            case ERROR: {
                return true;
            }
        }
        throw new IllegalArgumentException("Cannot handle log leve: " + level);
    }
}

