/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.logging;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.JDKLogAdapterFactory;
import org.ocpsoft.logging.spi.LogAdapterFactory;

public abstract class Logger {
    private static volatile LogAdapterFactory _adapterFactory = null;

    protected abstract void log(Level var1, String var2, Throwable var3);

    protected abstract boolean isEnabled(Level var1);

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public void trace(String msg) {
        this.log(Level.TRACE, msg, null);
    }

    public void trace(String msg, Object arg) {
        this.log(Level.TRACE, this.format(msg, new Object[]{arg}), null);
    }

    public void trace(String msg, Object arg1, Object arg2) {
        this.log(Level.TRACE, this.format(msg, new Object[]{arg1, arg2}), null);
    }

    public void trace(String msg, Object[] argArray) {
        this.log(Level.TRACE, this.format(msg, argArray), null);
    }

    public void trace(String msg, Throwable t) {
        this.log(Level.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg, null);
    }

    public void debug(String msg, Object arg) {
        this.log(Level.DEBUG, this.format(msg, new Object[]{arg}), null);
    }

    public void debug(String msg, Object arg1, Object arg2) {
        this.log(Level.DEBUG, this.format(msg, new Object[]{arg1, arg2}), null);
    }

    public void debug(String msg, Object[] argArray) {
        this.log(Level.DEBUG, this.format(msg, argArray), null);
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public void info(String msg, Object arg) {
        this.log(Level.INFO, this.format(msg, new Object[]{arg}), null);
    }

    public void info(String msg, Object arg1, Object arg2) {
        this.log(Level.INFO, this.format(msg, new Object[]{arg1, arg2}), null);
    }

    public void info(String msg, Object[] argArray) {
        this.log(Level.INFO, this.format(msg, argArray), null);
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public void warn(String msg) {
        this.log(Level.WARN, msg, null);
    }

    public void warn(String msg, Object arg) {
        this.log(Level.WARN, this.format(msg, new Object[]{arg}), null);
    }

    public void warn(String msg, Object arg1, Object arg2) {
        this.log(Level.WARN, this.format(msg, new Object[]{arg1, arg2}), null);
    }

    public void warn(String msg, Object[] argArray) {
        this.log(Level.WARN, this.format(msg, argArray), null);
    }

    public void warn(String msg, Throwable t) {
        this.log(Level.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public void error(String msg) {
        this.log(Level.ERROR, msg, null);
    }

    public void error(String msg, Object arg) {
        this.log(Level.ERROR, this.format(msg, new Object[]{arg}), null);
    }

    public void error(String msg, Object arg1, Object arg2) {
        this.log(Level.ERROR, this.format(msg, new Object[]{arg1, arg2}), null);
    }

    public void error(String msg, Object[] argArray) {
        this.log(Level.ERROR, this.format(msg, argArray), null);
    }

    public void error(String msg, Throwable t) {
        this.log(Level.ERROR, msg, t);
    }

    protected String format(String msg, Object[] args) {
        StringBuilder builder = new StringBuilder(msg);
        for (Object o : args) {
            int i = builder.indexOf("{}");
            if (i == -1) break;
            builder.replace(i, i + 2, o != null ? o.toString() : "null");
        }
        return builder.toString();
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String logger) {
        LogAdapterFactory adapterFactory = Logger.getAdapterFactory();
        return adapterFactory.createLogAdapter(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogAdapterFactory getAdapterFactory() {
        if (_adapterFactory != null) return _adapterFactory;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (_adapterFactory != null) return _adapterFactory;
            _adapterFactory = Logger.createAdapterFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _adapterFactory;
        }
    }

    private static LogAdapterFactory createAdapterFactory() {
        List<LogAdapterFactory> factories = Iterators.asList((Iterable)ServiceLoader.load(LogAdapterFactory.class));
        if (factories.isEmpty()) {
            factories = Arrays.asList(new JDKLogAdapterFactory());
        }
        Collections.sort(factories, new WeightedComparator());
        return (LogAdapterFactory)factories.get(0);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

