/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.redoculous.config;

import java.io.File;
import javax.servlet.ServletContext;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.redoculous.Redoculous;
import org.ocpsoft.redoculous.config.WatermarkInterceptor;
import org.ocpsoft.redoculous.config.git.CheckoutRefOperation;
import org.ocpsoft.redoculous.config.git.CloneRepositoryOperation;
import org.ocpsoft.redoculous.config.git.UpdateRepositoryOperation;
import org.ocpsoft.redoculous.config.util.CanonicalizeFileName;
import org.ocpsoft.redoculous.config.util.SafeFileNameTransposition;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Direction;
import org.ocpsoft.rewrite.config.Filesystem;
import org.ocpsoft.rewrite.config.Log;
import org.ocpsoft.rewrite.config.Not;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Subset;
import org.ocpsoft.rewrite.param.Transposition;
import org.ocpsoft.rewrite.servlet.config.DispatchType;
import org.ocpsoft.rewrite.servlet.config.HttpConfigurationProvider;
import org.ocpsoft.rewrite.servlet.config.Method;
import org.ocpsoft.rewrite.servlet.config.Path;
import org.ocpsoft.rewrite.servlet.config.Query;
import org.ocpsoft.rewrite.servlet.config.Response;
import org.ocpsoft.rewrite.servlet.config.SendStatus;
import org.ocpsoft.rewrite.servlet.config.Stream;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.transform.Transform;
import org.ocpsoft.rewrite.transform.Transformer;
import org.ocpsoft.rewrite.transform.markup.Asciidoc;

public class GitRepositoryConfigurationProvider
extends HttpConfigurationProvider {
    Transposition<String> safeFileName = new SafeFileNameTransposition();
    Transposition<String> canonicalizeFilename = new CanonicalizeFileName();

    public Configuration getConfiguration(ServletContext context) {
        File root = Redoculous.getRoot();
        return (Configuration)ConfigurationBuilder.begin().addRule().when((Condition)Direction.isInbound().and((Condition)Method.isPost()).and((Condition)Path.matches((String)"/update"))).perform((Operation)Log.message((Logger.Level)Logger.Level.INFO, (String)"Git post commit hook received.").and((Operation)new UpdateRepositoryOperation(root).and((Operation)Response.setStatus((int)200)).and((Operation)Response.complete()))).addRule().when((Condition)Direction.isInbound().and((Condition)DispatchType.isRequest()).and((Condition)Path.matches((String)"/serve")).and((Condition)Query.parameterExists((String)"repo")).and((Condition)Query.parameterExists((String)"ref")).and((Condition)Query.parameterExists((String)"path"))).perform((Operation)Log.message((Logger.Level)Logger.Level.INFO, (String)"Git resource requested [{repo}] [{ref}] [{path}]").and((Operation)Subset.evaluate((Configuration)ConfigurationBuilder.begin().addRule().perform((Operation)new CloneRepositoryOperation(root, "repo", "ref")).addRule().when((Condition)Not.any((Condition)Filesystem.directoryExists((File)new File(root, "{repo}/refs/{ref}")))).perform((Operation)new CheckoutRefOperation(root, "repo", "ref")).addRule().when((Condition)Filesystem.fileExists((File)new File(root, "{repo}/refs/{ref}/{path}.asciidoc"))).perform((Operation)Response.setContentType((String)"text/html").and((Operation)Response.addHeader((String)"Charset", (String)"UTF-8")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Origin", (String)"*")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Credentials", (String)"true")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Methods", (String)"GET, POST")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Headers", (String)"Content-Type, User-Agent, X-Requested-With, X-Requested-By, Cache-Control")).and((Operation)Response.setStatus((int)200)).and((Operation)Subset.evaluate((Configuration)ConfigurationBuilder.begin().addRule().when((Condition)Filesystem.fileExists((File)new File(root, "{repo}/caches/{ref}/{path}.html"))).perform((Operation)Stream.from((File)new File(root, "{repo}/caches/{ref}/{path}.html"))).otherwise((Operation)Transform.with((Transformer)Asciidoc.partialDocument()).and((Operation)Response.withOutputInterceptedBy((ResponseContentInterceptor[])new ResponseContentInterceptor[]{new WatermarkInterceptor()})).and(Stream.to((File)new File(root, "{repo}/caches/{ref}/{path}.html"))).and((Operation)Stream.from((File)new File(root, "{repo}/refs/{ref}/{path}.asciidoc")))))).and((Operation)Response.complete())).addRule().when((Condition)Filesystem.fileExists((File)new File(root, "{repo}/refs/{ref}/{path}/index.asciidoc"))).perform((Operation)Response.setContentType((String)"text/html").and((Operation)Response.addHeader((String)"Charset", (String)"UTF-8")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Origin", (String)"*")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Credentials", (String)"true")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Methods", (String)"GET, POST")).and((Operation)Response.addHeader((String)"Access-Control-Allow-Headers", (String)"Content-Type, User-Agent, X-Requested-With, X-Requested-By, Cache-Control")).and((Operation)Response.setStatus((int)200)).and((Operation)Subset.evaluate((Configuration)ConfigurationBuilder.begin().addRule().when((Condition)Filesystem.fileExists((File)new File(root, "{repo}/caches/{ref}/{path}/index.html"))).perform((Operation)Stream.from((File)new File(root, "{repo}/caches/{ref}/{path}/index.html"))).otherwise((Operation)Transform.with((Transformer)Asciidoc.partialDocument()).and((Operation)Response.withOutputInterceptedBy((ResponseContentInterceptor[])new ResponseContentInterceptor[]{new WatermarkInterceptor()})).and(Stream.to((File)new File(root, "{repo}/caches/{ref}/{path}/index.html"))).and((Operation)Stream.from((File)new File(root, "{repo}/refs/{ref}/{path}/index.asciidoc")))))).and((Operation)Response.complete())).addRule().perform((Operation)SendStatus.error((int)404))))).where("path").matches(".*").transposedBy(this.canonicalizeFilename).where("repo").transposedBy(this.safeFileName);
    }

    public int priority() {
        return 0;
    }
}

