/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.redoculous.config;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.redoculous.config.util.SafeFileNameTransposition;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContent;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptorChain;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.Metadata;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.urlbuilder.Address;

public class PreviewGitLinkInterceptor
implements ResponseContentInterceptor {
    private File root;

    public PreviewGitLinkInterceptor(File root) {
        this.root = root;
    }

    public void intercept(HttpServletRewrite event, ResponseContent buffer, ResponseContentInterceptorChain chain) {
        chain.proceed();
        Address address = event.getAddress();
        String contents = new String(buffer.getContents());
        Pattern pattern = Pattern.compile("(<a[^>]+href\\s*=\\s*(?:[\"']))([^\"']+)");
        Matcher matcher = pattern.matcher(contents);
        StringBuffer temp = new StringBuffer();
        while (matcher.find()) {
            String linkPrefix = matcher.group(1);
            String url = matcher.group(2);
            String requestedPath = ((HttpServletRequest)event.getRequest()).getParameter("path");
            String requestedRef = ((HttpServletRequest)event.getRequest()).getParameter("ref");
            String requestedRepo = ((HttpServletRequest)event.getRequest()).getParameter("repo");
            File refDir = new File(this.root, SafeFileNameTransposition.toSafeFilename((String)requestedRepo) + "/refs/" + requestedRef);
            File requestedFile = new File(refDir, requestedPath);
            if (requestedFile.isDirectory()) {
                requestedFile = new File(requestedFile, "index");
                if (!requestedPath.endsWith("/")) {
                    requestedPath = requestedPath + "/";
                }
                requestedPath = requestedPath + "index";
            }
            if (url.matches("^(\\w+://|www\\.|/).*")) continue;
            URLBuilder urlBuilder = URLBuilder.createFrom((String)requestedPath);
            ArrayList segments = new ArrayList(urlBuilder.getSegments());
            if (url.startsWith(".")) {
                while (!segments.isEmpty()) {
                    if (url.startsWith("../")) {
                        url = url.substring(3);
                        segments.remove(segments.size() - 1);
                        continue;
                    }
                    if (!url.startsWith("./")) break;
                    url = url.substring(2);
                }
            }
            if (!requestedFile.isDirectory() && !segments.isEmpty()) {
                segments.remove(segments.size() - 1);
            }
            String result = URLBuilder.createFrom(segments, (Metadata)urlBuilder.getMetadata()).toPath();
            if (!url.startsWith("/") && !result.endsWith("/")) {
                url = "/" + url;
            }
            result = result + url;
            QueryStringBuilder query = QueryStringBuilder.createNew();
            query.addParameters(address.getQuery());
            query.removeParameter("path");
            query.addParameter("path", new String[]{result});
            matcher.appendReplacement(temp, linkPrefix + query.toQueryString());
        }
        matcher.appendTail(temp);
        buffer.setContents(temp.toString().getBytes());
    }
}

