/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.redoculous.config.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.redoculous.config.util.OperatingSystemUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Files {
    public static final String HOME_ALIAS = "~";
    public static final String SLASH = File.separator;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FIFTY_MB = 0x3200000L;
    public static final long ONE_GB = 0x40000000L;

    public static boolean delete(File file) {
        return Files.delete((File)file, (boolean)false);
    }

    public static void deleteOnExit(File file) {
        file.deleteOnExit();
    }

    public static boolean delete(File file, boolean recursive) {
        if (recursive) {
            return Files._deleteRecursive((File)file, (boolean)true);
        }
        if (file.listFiles() != null && file.listFiles().length != 0) {
            throw new RuntimeException("directory not empty");
        }
        if (OperatingSystemUtils.isWindows()) {
            System.gc();
        }
        file.deleteOnExit();
        return file.delete();
    }

    private static boolean _deleteRecursive(File file, boolean collect) {
        if (collect && OperatingSystemUtils.isWindows()) {
            System.gc();
        }
        if (file == null) {
            return false;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File sf : children) {
                if (sf.isDirectory()) {
                    Files._deleteRecursive((File)sf, (boolean)false);
                    continue;
                }
                if (sf.delete()) continue;
                throw new RuntimeException("failed to delete: " + sf.getAbsolutePath());
            }
        }
        return file.delete();
    }

    public static String canonicalize(String target) {
        if (target.startsWith("~")) {
            String homePath = OperatingSystemUtils.getUserHomePath();
            target = homePath + target.substring(1, target.length());
        }
        return target;
    }

    public static File getWorkingDirectory() {
        return new File("").getAbsoluteFile();
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        File destFile = new File(destDir, srcFile.getName());
        Files.copyFile((File)srcFile, (File)destFile);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' exists but is a directory");
        }
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
        }
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + destFile + "' directory cannot be created");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException("Destination '" + destFile + "' exists but is read-only");
        }
        Files.doCopyFile((File)srcFile, (File)destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > 0x3200000L ? 0x3200000L : size - pos;
            }
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(output);
            Streams.closeQuietly(fos);
            Streams.closeQuietly(input);
            Streams.closeQuietly((Closeable)fis);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)output);
        Streams.closeQuietly((Closeable)fos);
        Streams.closeQuietly((Closeable)input);
        Streams.closeQuietly((Closeable)fis);
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        Files.copyDirectory((File)srcDir, (File)destDir, null);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            File[] srcFiles;
            File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
            if (srcFiles != null && srcFiles.length > 0) {
                exclusionList = new ArrayList<String>(srcFiles.length);
                for (File srcFile : srcFiles) {
                    File copiedFile = new File(destDir, srcFile.getName());
                    exclusionList.add(copiedFile.getCanonicalPath());
                }
            }
        }
        Files.doCopyDirectory((File)srcDir, (File)destDir, (FileFilter)filter, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter, List<String> exclusionList) throws IOException {
        File[] srcFiles;
        File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                Files.doCopyDirectory((File)srcFile, (File)dstFile, (FileFilter)filter, exclusionList);
                continue;
            }
            Files.doCopyFile((File)srcFile, (File)dstFile);
        }
    }
}

