/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.annotation.api.Parameter;

public class ParameterImpl
implements Parameter {
    private final Method method;
    private final Class<?> type;
    private final List<Annotation> annotations;
    private final int index;

    public ParameterImpl(Method method, Class<?> type, Annotation[] annotations, int index) {
        this.method = method;
        this.type = type;
        this.annotations = Arrays.asList(annotations);
        this.index = index;
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        for (Annotation a : this.annotations) {
            if (!type.equals(a.annotationType())) continue;
            return (T)a;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.annotations.toArray(new Annotation[0]);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> type) {
        return this.getAnnotation(type) != null;
    }

    public Method getDeclaringMethod() {
        return this.method;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getType() {
        return this.type;
    }
}

