/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.el;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.el.ConstantExpression;
import org.ocpsoft.rewrite.el.Expression;
import org.ocpsoft.rewrite.el.TypeBasedExpression;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;

public abstract class El
extends BindingBuilder<El, Object>
implements Retrieval {
    private static final Logger log = Logger.getLogger(El.class);
    private static volatile List<ExpressionLanguageProvider> _providers;

    public static El methodBinding(String retrieve, String submit) {
        return new ElMethod(new ConstantExpression(retrieve), new ConstantExpression(submit));
    }

    public static El retrievalMethod(String expression) {
        return new ElMethod(new ConstantExpression(expression), null);
    }

    public static El retrievalMethod(Method method) {
        return new ElMethod(new TypeBasedExpression(method.getDeclaringClass(), method.getName()), null);
    }

    public static El retrievalMethod(String expression, Class<? extends Converter<?>> converterType) {
        ElMethod el = new ElMethod(new ConstantExpression(expression), null);
        el.convertedBy(converterType);
        return el;
    }

    public static El submissionMethod(String expression) {
        return new ElMethod(null, new ConstantExpression(expression));
    }

    public static El submissionMethod(String expression, Class<? extends Converter<?>> converterType) {
        ElMethod el = new ElMethod(null, new ConstantExpression(expression));
        el.convertedBy(converterType);
        return el;
    }

    public static El submissionMethod(String expression, Class<? extends Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        ElMethod el = new ElMethod(null, new ConstantExpression(expression));
        el.convertedBy(converterType);
        el.validatedBy(validatorType);
        return el;
    }

    public static El property(String expression) {
        return new ElProperty(new ConstantExpression(expression));
    }

    public static El property(Field field) {
        return new ElProperty(new TypeBasedExpression(field.getDeclaringClass(), field.getName()));
    }

    public static El property(String expression, Class<? extends Converter<?>> type) {
        ElProperty el = new ElProperty(new ConstantExpression(expression));
        el.convertedBy(type);
        return el;
    }

    public static El property(String expression, Class<? extends Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        ElProperty el = new ElProperty(new ConstantExpression(expression));
        el.convertedBy(converterType);
        el.validatedBy(validatorType);
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<ExpressionLanguageProvider> getProviders() {
        if (_providers != null) return _providers;
        Class<El> clazz = El.class;
        synchronized (El.class) {
            if (_providers != null) return _providers;
            _providers = Iterators.asList((Iterable)ServiceLoader.load(ExpressionLanguageProvider.class));
            Collections.sort(_providers, new WeightedComparator());
            if (!_providers.isEmpty()) return _providers;
            log.warn("No instances of [{}] were configured. EL support is disabled.", (Object)ExpressionLanguageProvider.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _providers;
        }
    }

    public static class ElProperty
    extends El {
        private final Expression expression;

        public ElProperty(Expression expression) {
            this.expression = expression;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            Object value = null;
            for (ExpressionLanguageProvider provider : El.getProviders()) {
                try {
                    value = provider.retrieveValue(this.expression.getExpression());
                    break;
                }
                catch (UnsupportedOperationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not extract value from property [" + this.expression + "]", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not extract value from property [" + this.expression + "]", (Throwable)e);
                }
                if (value == null) continue;
                break;
            }
            return value;
        }

        public boolean supportsRetrieval() {
            return true;
        }

        public boolean supportsSubmission() {
            return true;
        }

        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            for (ExpressionLanguageProvider provider : El.getProviders()) {
                try {
                    provider.submitValue(this.expression.getExpression(), value);
                    break;
                }
                catch (UnsupportedOperationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not inject property [" + this.expression + "} with value [" + value + "]", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not inject property [" + this.expression + "} with value [" + value + "]", (Throwable)e);
                }
            }
            return null;
        }

        public String toString() {
            return "ElProperty [ " + this.expression + " ]";
        }
    }

    public static class ElMethod
    extends El {
        private final Expression getExpression;
        private final Expression setExpression;

        public ElMethod(Expression getExpression, Expression setExpression) {
            this.getExpression = getExpression;
            this.setExpression = setExpression;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (!this.supportsRetrieval()) {
                throw new RewriteException("Method binding expression supports submission only [" + this.setExpression + "], no value retrieval expression was defined");
            }
            Object value = null;
            for (ExpressionLanguageProvider provider : El.getProviders()) {
                try {
                    return provider.evaluateMethodExpression(this.getExpression.getExpression());
                }
                catch (UnsupportedOperationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not invoke method [" + this.getExpression + "]", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not retrieve value from property [" + this.getExpression + "]", (Throwable)e);
                }
            }
            return value;
        }

        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            if (!this.supportsSubmission()) {
                throw new RewriteException("Method binding expression supports retrieval only [" + this.getExpression + "], no value submission expression was defined");
            }
            for (ExpressionLanguageProvider provider : El.getProviders()) {
                try {
                    return provider.evaluateMethodExpression(this.setExpression.getExpression(), value);
                }
                catch (UnsupportedOperationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not submit method [" + this.setExpression + "} with value [" + value + "]", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not submit method [" + this.setExpression + "} with value [" + value + "]", (Throwable)e);
                }
            }
            return null;
        }

        public boolean supportsRetrieval() {
            return this.getExpression != null;
        }

        public boolean supportsSubmission() {
            return this.setExpression != null;
        }

        public String toString() {
            return "ElMethod [retrieve= [ " + this.getExpression + " }, submit= [ " + this.setExpression + " ]";
        }
    }
}

