/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.el;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.el.ConstantExpression;
import org.ocpsoft.rewrite.el.Expression;
import org.ocpsoft.rewrite.el.ProviderCallable;
import org.ocpsoft.rewrite.el.TypeBasedExpression;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;

public abstract class El
implements Binding,
Retrieval {
    private static final Logger log = Logger.getLogger(El.class);
    private static volatile List<ExpressionLanguageProvider> _providers;

    public static El method(String retrieve, String submit) {
        return new ElMethod(new ConstantExpression(retrieve), new ConstantExpression(submit));
    }

    public static El retrievalMethod(String expression) {
        return new ElMethod(new ConstantExpression(expression), null);
    }

    public static El retrievalMethod(Method method) {
        return El.retrievalMethod(method.getDeclaringClass(), method.getName());
    }

    public static El retrievalMethod(Class<?> clazz, String methodName) {
        return new ElMethod(new TypeBasedExpression(clazz, methodName), null);
    }

    public static El submissionMethod(String expression) {
        return new ElMethod(null, new ConstantExpression(expression));
    }

    public static El property(String expression) {
        return new ElProperty(new ConstantExpression(expression));
    }

    public static El property(Field field) {
        return El.property(field.getDeclaringClass(), field.getName());
    }

    public static El property(Class<?> clazz, String fieldName) {
        return new ElProperty(new TypeBasedExpression(clazz, fieldName));
    }

    public static El properties(String submit, String retrieve) {
        return new ElProperties(new ConstantExpression(submit), new ConstantExpression(retrieve));
    }

    public static El properties(Field submit, Field retrieve) {
        return new ElProperties(new TypeBasedExpression(submit.getDeclaringClass(), submit.getName()), new TypeBasedExpression(retrieve.getDeclaringClass(), retrieve.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<ExpressionLanguageProvider> getProviders() {
        if (_providers != null) return _providers;
        Class<El> clazz = El.class;
        synchronized (El.class) {
            if (_providers != null) return _providers;
            _providers = Iterators.asList((Iterable)ServiceLoader.load(ExpressionLanguageProvider.class));
            Collections.sort(_providers, new WeightedComparator());
            if (!_providers.isEmpty()) return _providers;
            log.warn("No instances of [{}] were configured. EL support is disabled.", (Object)ExpressionLanguageProvider.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _providers;
        }
    }

    private static Object executeProviderCallable(Rewrite event, EvaluationContext context, ProviderCallable<Object> providerCallable) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ExpressionLanguageProvider provider : El.getProviders()) {
            try {
                return providerCallable.call(event, context, provider);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        for (Exception exception : exceptions) {
            log.error("DEFERRED EXCEPTION", (Throwable)exception);
        }
        throw new RewriteException("No registered " + ExpressionLanguageProvider.class.getName() + " could handle the Expression [" + providerCallable.getExpression() + "]");
    }

    public static class ElProperties
    extends El {
        private Expression submit;
        private Expression retrieve;

        public ElProperties(Expression submit, Expression retrieve) {
            this.submit = submit;
            this.retrieve = retrieve;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            return El.executeProviderCallable(event, context, new ProviderCallable<Object>(){

                @Override
                public Object call(Rewrite event, EvaluationContext context, ExpressionLanguageProvider provider) throws Exception {
                    return provider.retrieveValue(ElProperties.this.retrieve.getExpression());
                }

                @Override
                public String getExpression() {
                    return ElProperties.this.retrieve.getExpression();
                }
            });
        }

        public Object submit(Rewrite event, EvaluationContext context, final Object value) {
            return El.executeProviderCallable(event, context, new ProviderCallable<Object>(){

                @Override
                public Object call(Rewrite event, EvaluationContext context, ExpressionLanguageProvider provider) throws Exception {
                    provider.submitValue(ElProperties.this.submit.getExpression(), value);
                    return null;
                }

                @Override
                public String getExpression() {
                    return ElProperties.this.submit.getExpression();
                }
            });
        }

        public boolean supportsRetrieval() {
            return true;
        }

        public boolean supportsSubmission() {
            return true;
        }

        public String toString() {
            return "ElProperties [ submitTo =>" + this.submit + ", retrieveFrom=>" + this.retrieve + " ]";
        }
    }

    public static class ElProperty
    extends El {
        private final Expression expression;

        public ElProperty(Expression expression) {
            this.expression = expression;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            return El.executeProviderCallable(event, context, new ProviderCallable<Object>(){

                @Override
                public Object call(Rewrite event, EvaluationContext context, ExpressionLanguageProvider provider) throws Exception {
                    return provider.retrieveValue(ElProperty.this.expression.getExpression());
                }

                @Override
                public String getExpression() {
                    return ElProperty.this.expression.getExpression();
                }
            });
        }

        public Object submit(Rewrite event, EvaluationContext context, final Object value) {
            return El.executeProviderCallable(event, context, new ProviderCallable<Object>(){

                @Override
                public Object call(Rewrite event, EvaluationContext context, ExpressionLanguageProvider provider) throws Exception {
                    provider.submitValue(ElProperty.this.expression.getExpression(), value);
                    return null;
                }

                @Override
                public String getExpression() {
                    return ElProperty.this.expression.getExpression();
                }
            });
        }

        public boolean supportsRetrieval() {
            return true;
        }

        public boolean supportsSubmission() {
            return true;
        }

        public String toString() {
            return "ElProperty [ " + this.expression + " ]";
        }
    }

    public static class ElMethod
    extends El {
        private final Expression getExpression;
        private final Expression setExpression;

        public ElMethod(Expression getExpression, Expression setExpression) {
            this.getExpression = getExpression;
            this.setExpression = setExpression;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (!this.supportsRetrieval()) {
                throw new RewriteException("Method binding expression supports submission only [" + this.setExpression + "], no value retrieval expression was defined");
            }
            return El.executeProviderCallable(event, context, new ProviderCallable<Object>(){

                @Override
                public Object call(Rewrite event, EvaluationContext context, ExpressionLanguageProvider provider) throws Exception {
                    return provider.evaluateMethodExpression(ElMethod.this.getExpression.getExpression());
                }

                @Override
                public String getExpression() {
                    return ElMethod.this.getExpression.getExpression();
                }
            });
        }

        public Object submit(Rewrite event, EvaluationContext context, final Object value) {
            if (!this.supportsSubmission()) {
                throw new RewriteException("Method binding expression supports retrieval only [" + this.getExpression + "], no value submission expression was defined");
            }
            return El.executeProviderCallable(event, context, new ProviderCallable<Object>(){

                @Override
                public Object call(Rewrite event, EvaluationContext context, ExpressionLanguageProvider provider) throws Exception {
                    return provider.evaluateMethodExpression(ElMethod.this.setExpression.getExpression(), value);
                }

                @Override
                public String getExpression() {
                    return ElMethod.this.setExpression.getExpression();
                }
            });
        }

        public boolean supportsRetrieval() {
            return this.getExpression != null;
        }

        public boolean supportsSubmission() {
            return this.setExpression != null;
        }

        public String toString() {
            return "ElMethod [retrieve= [ " + this.getExpression + " }, submit= [ " + this.setExpression + " ]";
        }
    }
}

