/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.el;

import java.util.ArrayList;
import java.util.Iterator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.ELBeanName;
import org.ocpsoft.rewrite.el.Expression;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;

class TypeBasedExpression
implements Expression {
    private static Logger log = Logger.getLogger(TypeBasedExpression.class);
    private final Class<?> clazz;
    private final String component;
    private String cachedExpression;

    public TypeBasedExpression(Class<?> clazz, String component) {
        this.clazz = clazz;
        this.component = component;
    }

    @Override
    public String getExpression() {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.lookupBeanName();
        }
        return this.cachedExpression;
    }

    private String lookupBeanName() {
        Iterator iterator = ServiceLoader.load(BeanNameResolver.class).iterator();
        ArrayList<Exception> deferred = new ArrayList<Exception>();
        while (iterator.hasNext()) {
            BeanNameResolver resolver = (BeanNameResolver)iterator.next();
            try {
                String beanName = resolver.getBeanName(this.clazz);
                if (log.isTraceEnabled()) {
                    log.trace("Service provider [{}] returned [{}] for class [{}]", new Object[]{resolver.getClass().getSimpleName(), beanName, this.clazz.getName()});
                }
                if (beanName == null) continue;
                String el = beanName + '.' + this.component;
                if (log.isTraceEnabled()) {
                    log.debug("Creation of EL expression for component [{}] of class [{}] successful: {}", new Object[]{this.component, this.clazz.getName(), el});
                }
                return el;
            }
            catch (Exception e) {
                log.debug("Failed to resolve bean names using [" + resolver.getClass().getName() + "]", (Throwable)e);
                deferred.add(e);
            }
        }
        if (deferred.size() > 1) {
            for (Exception e : deferred) {
                log.error("Failed to resolve bean names.", (Throwable)e);
            }
        }
        throw new IllegalStateException("Unable to obtain EL name for bean of type [" + this.clazz.getName() + "] from any of the SPI implementations. You should conside placing a @" + ELBeanName.class.getSimpleName() + " on the class.", deferred.size() == 1 ? (Throwable)deferred.get(0) : null);
    }

    public String toString() {
        return this.getExpression();
    }
}

