/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.exception.RewriteException;

public class QueryStringBuilder {
    private static final Logger log = Logger.getLogger(QueryStringBuilder.class);
    private final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();

    public static QueryStringBuilder createNew() {
        return new QueryStringBuilder();
    }

    public static QueryStringBuilder createFromEncoded(String parameters) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        queryString.addParameters(parameters);
        return queryString;
    }

    public static QueryStringBuilder createFromArrays(Map<String, String[]> params) {
        return QueryStringBuilder.createNew().addParameterArrays(params);
    }

    public static QueryStringBuilder createFromLists(Map<String, List<String>> params) {
        return QueryStringBuilder.createNew().addParameterLists(params);
    }

    public static String extractQuery(String url) {
        int index;
        if (url != null && (index = url.indexOf(63)) >= 0) {
            url = url.substring(index + 1);
        }
        return url;
    }

    public QueryStringBuilder addParameters(String url) {
        String temp = QueryStringBuilder.extractQuery(url);
        if (temp != null) {
            temp = this.decodeHTMLAmpersands(temp);
            int index = 0;
            while ((index = temp.indexOf(38)) >= 0 || !temp.isEmpty()) {
                String value;
                String name;
                int pos;
                String pair = temp;
                if (index >= 0) {
                    pair = temp.substring(0, index);
                    if (!(temp = temp.substring(index)).isEmpty()) {
                        temp = temp.substring(1);
                    }
                } else {
                    temp = "";
                }
                if ((pos = pair.indexOf(61)) == -1) {
                    name = pair;
                    value = null;
                } else {
                    name = pair.substring(0, pos);
                    value = pair.substring(pos + 1, pair.length());
                }
                List<String> list = this.parameters.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.parameters.put(name, list);
                }
                list.add(value);
            }
        }
        return this;
    }

    private String decodeHTMLAmpersands(String url) {
        if (url != null) {
            int index = 0;
            while ((index = url.indexOf("&amp;")) >= 0) {
                url = url.substring(0, index + 1) + url.substring(index + 5);
            }
        }
        return url;
    }

    public void addParameter(String name, String ... values) {
        LinkedHashMap<String, String[]> parameter = new LinkedHashMap<String, String[]>();
        parameter.put(name, values);
        this.addParameterArrays(parameter);
    }

    public QueryStringBuilder addParameterArrays(Map<String, String[]> params) {
        if (params != null) {
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                List<Object> values = null;
                if (entry.getValue() != null) {
                    values = Arrays.asList((Object[])entry.getValue());
                }
                this.parameters.put(entry.getKey(), values);
            }
        }
        return this;
    }

    public QueryStringBuilder addParameterLists(Map<String, List<String>> params) {
        if (params != null) {
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                ArrayList values = null;
                if (entry.getValue() != null) {
                    values = new ArrayList(entry.getValue());
                }
                this.parameters.put(entry.getKey(), values);
            }
        }
        return this;
    }

    public QueryStringBuilder decode() {
        return new QueryStringBuilder().addParameterLists(this.getParameterMap(new QSDecoder()));
    }

    public QueryStringBuilder encode() {
        return new QueryStringBuilder().addParameterLists(this.getParameterMap(new QSEncoder()));
    }

    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "";
        }
        return values.get(0);
    }

    public Map<String, List<String>> getParameterMap() {
        return this.getParameterMap(new NullEncodingHandler());
    }

    private Map<String, List<String>> getParameterMap(EncodingHandler handler) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            String key = handler.encode(entry.getKey());
            ArrayList<String> values = new ArrayList<String>();
            for (String value : entry.getValue()) {
                if (value == null) continue;
                values.add(handler.encode(value));
            }
            map.put(key, new ArrayList(values));
        }
        return map;
    }

    public Set<String> getParameterNames() {
        return new LinkedHashSet<String>(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public List<String> removeParameter(String string) {
        return this.parameters.remove(string);
    }

    public String toQueryString() {
        StringBuilder result = new StringBuilder();
        if (null != this.parameters && !this.parameters.isEmpty()) {
            result.append("?");
            Iterator<Map.Entry<String, List<String>>> iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<String>> entry = iterator.next();
                String key = entry.getKey();
                List<String> values = entry.getValue();
                if (key != null && !"".equals(key)) {
                    result.append(key);
                    if (values != null && !values.isEmpty()) {
                        for (int i = 0; i < values.size(); ++i) {
                            String value = values.get(i);
                            if (value != null && !"".equals(value)) {
                                result.append("=" + value);
                            } else if (value != null && "".equals(value)) {
                                result.append("=");
                            }
                            if (i >= values.size() - 1) continue;
                            result.append("&" + key);
                        }
                    }
                }
                if (!iterator.hasNext()) continue;
                result.append("&");
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toQueryString();
    }

    private class QSEncoder
    implements EncodingHandler {
        private QSEncoder() {
        }

        @Override
        public String encode(String value) {
            try {
                return URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RewriteException("Encoding type UTF-8 is not supported by this JVM.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not encode query parameter: " + value);
                return value;
            }
        }
    }

    private class QSDecoder
    implements EncodingHandler {
        private QSDecoder() {
        }

        @Override
        public String encode(String value) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RewriteException("Encoding type UTF-8 is not supported by this JVM.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not decode query parameter: " + value);
                return value;
            }
        }
    }

    private class NullEncodingHandler
    implements EncodingHandler {
        private NullEncodingHandler() {
        }

        @Override
        public String encode(String value) {
            return value;
        }
    }

    private static interface EncodingHandler {
        public String encode(String var1);
    }
}

