/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.proxy;

import java.util.LinkedHashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.Lifecycle;
import org.ocpsoft.rewrite.servlet.config.proxy.ProxyServlet;
import org.ocpsoft.rewrite.servlet.config.proxy.ProxyServletConfig;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public final class Proxy
extends HttpOperation
implements Parameterized {
    private final ParameterizedPatternBuilder destination;

    private Proxy(String destination) {
        this.destination = new RegexParameterizedPatternBuilder(destination);
    }

    public static Proxy to(String destination) {
        return new Proxy(destination);
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("targetUri", this.destination.build((Rewrite)event, context));
        ProxyServlet proxyServlet = new ProxyServlet();
        ProxyServletConfig proxyConfig = new ProxyServletConfig(event.getServletContext(), params);
        try {
            proxyServlet.init(proxyConfig);
            proxyServlet.service((HttpServletRequest)event.getRequest(), (HttpServletResponse)event.getResponse());
            Lifecycle.abort().perform((Rewrite)event, context);
        }
        catch (Exception e) {
            throw new RewriteException("Could not proxy event [" + event + "] to destination [" + this.destination + "]", (Throwable)e);
        }
    }

    public Set<String> getRequiredParameterNames() {
        return this.destination.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.destination.setParameterStore(store);
    }
}

