/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.proxy;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.EntityUtils;
import org.ocpsoft.logging.Logger;

public class ProxyServlet {
    private static final long serialVersionUID = -362164247914670579L;
    public static final String P_LOG = "log";
    private static final String P_TARGET_URI = "targetUri";
    protected boolean doLog = false;
    protected URI targetUriObj;
    protected String targetUri;
    protected CloseableHttpClient proxyClient;
    private ServletConfig servletConfig;
    private static final Logger logger;
    protected static final HeaderGroup hopByHopHeaders;
    protected static final BitSet asciiQueryChars;

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        String doLogStr = servletConfig.getInitParameter(P_LOG);
        if (doLogStr != null) {
            this.doLog = Boolean.parseBoolean(doLogStr);
        }
        try {
            this.targetUriObj = new URI(servletConfig.getInitParameter(P_TARGET_URI));
        }
        catch (Exception e) {
            throw new RuntimeException("Trying to process targetUri init parameter: " + e, e);
        }
        this.targetUri = this.targetUriObj.toString();
        this.proxyClient = HttpClientBuilder.create().build();
    }

    public void destroy() {
        try {
            if (this.proxyClient != null) {
                this.proxyClient.close();
            }
        }
        catch (IOException e) {
            logger.error("The proxyClient threw an exception on closing.", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        BasicHttpRequest proxyRequest;
        String method = servletRequest.getMethod();
        if (servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null) {
            BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, this.targetUri);
            eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)servletRequest.getInputStream(), (long)servletRequest.getContentLength()));
            proxyRequest = eProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(method, this.targetUri);
        }
        this.copyRequestHeaders(servletRequest, (HttpRequest)proxyRequest);
        try {
            int statusCode;
            CloseableHttpResponse proxyResponse;
            if (this.doLog) {
                logger.debug("proxy " + method + " uri: " + servletRequest.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
            }
            if (this.doResponseRedirectOrNotModifiedLogic(servletRequest, servletResponse, (HttpResponse)(proxyResponse = this.proxyClient.execute(URIUtils.extractHost((URI)this.targetUriObj), (HttpRequest)proxyRequest)), statusCode = proxyResponse.getStatusLine().getStatusCode())) {
                EntityUtils.consume((HttpEntity)proxyResponse.getEntity());
                return;
            }
            this.setResponseStatus(servletResponse, statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseHeaders((HttpResponse)proxyResponse, servletResponse);
            this.copyResponseEntity((HttpResponse)proxyResponse, servletResponse);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void setResponseStatus(HttpServletResponse servletResponse, int statusCode, String reason) {
        servletResponse.setStatus(statusCode, reason);
    }

    protected boolean doResponseRedirectOrNotModifiedLogic(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader == null) {
                throw new ServletException("Received status code: " + statusCode + " but no Location header was found in the response");
            }
            String locStr = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue());
            servletResponse.sendRedirect(locStr);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                Object headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host")) {
                    HttpHost host = URIUtils.extractHost((URI)this.targetUriObj);
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = (String)headerValue + ":" + host.getPort();
                    }
                }
                proxyRequest.addHeader(headerName, (String)headerValue);
            }
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            try {
                entity.writeTo((OutputStream)servletOutputStream);
            }
            finally {
                this.closeQuietly((Closeable)servletOutputStream);
            }
        }
    }

    protected String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl) {
        if (((String)theUrl).startsWith(this.targetUri)) {
            String curUrl = servletRequest.getRequestURL().toString();
            String pathInfo = servletRequest.getPathInfo();
            if (pathInfo != null) {
                assert (curUrl.endsWith(pathInfo));
                curUrl = curUrl.substring(0, curUrl.length() - pathInfo.length());
            }
            theUrl = curUrl + ((String)theUrl).substring(this.targetUri.length());
        }
        return theUrl;
    }

    protected static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        logger = Logger.getLogger(ProxyServlet.class);
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

