/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Transpositions;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public abstract class Substitute
extends HttpOperation
implements Parameterized {
    private final ParameterizedPatternParser location;

    private Substitute(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null.");
        this.location = new RegexParameterizedPatternParser("[^/]+", location);
    }

    public static Substitute with(final String location) {
        return new Substitute(location){

            public String toString() {
                return "Substitute.with(\"" + location + "\")";
            }
        };
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.getBuilder().build((Rewrite)event, context, Transpositions.encodePath());
            ((HttpInboundServletRewrite)event).forward(target);
        } else if (event instanceof HttpOutboundServletRewrite) {
            ParameterizedPatternBuilder builder = this.location.getBuilder();
            Object target = builder.build((Rewrite)event, context, Transpositions.encodePath());
            if (((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPath().startsWith(event.getContextPath()) && ((String)target).startsWith("/") && !((String)target).startsWith("//") && !((String)target).startsWith(event.getContextPath())) {
                target = event.getContextPath() + (String)target;
            }
            ((HttpOutboundServletRewrite)event).setOutboundAddress(AddressBuilder.create((String)target));
        }
    }

    public ParameterizedPatternParser getExpression() {
        return this.location;
    }

    public Set<String> getRequiredParameterNames() {
        return this.location.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.location.setParameterStore(store);
    }
}

