/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IScheme;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Scheme
extends HttpCondition
implements IScheme {
    private final ParameterizedPatternParser expression;
    private final ParameterStore<IScheme.SchemeParameter> parameters = new ParameterStore();

    private Scheme(String pattern) {
        Assert.notNull((Object)pattern, (String)"Scheme must not be null.");
        this.expression = new RegexParameterizedPatternParser(pattern);
        for (ParameterizedPatternParserParameter parameter : this.expression.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public static Scheme matches(String pattern) {
        return new Scheme(pattern);
    }

    public IScheme.SchemeParameter where(String param) {
        return (IScheme.SchemeParameter)this.parameters.where(param, (ParameterBuilder)new IScheme.SchemeParameter(this, (ParameterizedPatternParserParameter)this.expression.getParameter(param)));
    }

    public IScheme.SchemeParameter where(String param, Binding binding) {
        return (IScheme.SchemeParameter)this.where(param).bindsTo(binding);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String scheme = null;
        if (event instanceof HttpOutboundServletRewrite) {
            scheme = event.getAddress().getProtocol();
            if (scheme == null) {
                scheme = ((HttpServletRequest)event.getRequest()).getScheme();
            }
        } else {
            scheme = ((HttpServletRequest)event.getRequest()).getScheme();
        }
        if (scheme != null && this.expression.matches((Rewrite)event, context, scheme)) {
            Map parameters = this.expression.parse((Rewrite)event, context, scheme);
            for (ParameterizedPatternParserParameter capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

