/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.rule;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.DispatchType;
import org.ocpsoft.rewrite.servlet.config.Forward;
import org.ocpsoft.rewrite.servlet.config.IPath;
import org.ocpsoft.rewrite.servlet.config.Path;
import org.ocpsoft.rewrite.servlet.config.Query;
import org.ocpsoft.rewrite.servlet.config.Redirect;
import org.ocpsoft.rewrite.servlet.config.Substitute;
import org.ocpsoft.rewrite.servlet.config.rule.IJoin;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.urlbuilder.Address;

public class Join
implements IJoin {
    private static final String JOIN_DISABLED_KEY = Join.class.getName() + "_DISABLED";
    private static final String CURRENT_JOIN = Join.class.getName() + "_current";
    private String id;
    private final String requestPattern;
    private String resourcePattern;
    private final IPath requestPath;
    private IPath resourcePath;
    private Operation operation;
    private Condition condition;
    private boolean inboundCorrection = false;
    private boolean chainingDisabled = true;
    private List<String> pathRequestParameters;
    private ConditionBuilder outboundConditionCache;

    protected Join(String pattern, boolean requestBinding) {
        this.requestPattern = pattern;
        this.requestPath = Path.matches(pattern);
        if (requestBinding) {
            this.requestPath.withRequestBinding();
        }
    }

    public static IJoin path(String pattern) {
        return new Join(pattern, true);
    }

    public static Join nonBindingPath(String pattern) {
        return new Join(pattern, false);
    }

    public static Join getCurrentJoin(HttpServletRequest request) {
        return (Join)request.getAttribute(CURRENT_JOIN);
    }

    @Override
    public IJoin to(String resource) {
        if (this.resourcePattern != null) {
            throw new IllegalStateException("Cannot set resource path more than once.");
        }
        this.resourcePattern = resource;
        this.resourcePath = Path.matches(resource);
        List<String> parameters = this.getPathRequestParameters();
        if (this.outboundConditionCache == null) {
            this.outboundConditionCache = this.resourcePath;
            for (int i = 0; i < parameters.size(); ++i) {
                String name = parameters.get(i);
                this.outboundConditionCache = this.outboundConditionCache.and((Condition)Query.parameterExists(name));
            }
        }
        return this;
    }

    @Override
    public IJoin withInboundCorrection() {
        this.inboundCorrection = true;
        return this;
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            if (!this.isChainingDisabled(event) && this.requestPath.evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                if (this.operation != null) {
                    context.addPreOperation(this.operation);
                }
                return true;
            }
            if (this.inboundCorrection && this.resourcePath.andNot((Condition)DispatchType.isForward()).evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                List<String> parameters = this.getPathRequestParameters();
                for (String param : parameters) {
                    if (Query.parameterExists(param).evaluate(event, context)) continue;
                    return false;
                }
                context.addPreOperation((Operation)Redirect.permanent(((HttpInboundServletRewrite)event).getContextPath() + this.requestPattern));
                return true;
            }
        } else if (event instanceof HttpOutboundServletRewrite && this.outboundConditionCache.evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
            if (this.operation != null) {
                context.addPreOperation(this.operation);
            }
            return true;
        }
        return false;
    }

    private boolean isChainingDisabled(Rewrite event) {
        return Boolean.TRUE.equals(event.getRewriteContext().get((Object)JOIN_DISABLED_KEY));
    }

    private List<String> getPathRequestParameters() {
        if (this.pathRequestParameters == null) {
            List nonQueryParameters = this.resourcePath.getPathExpression().getParameterNames();
            List queryParameters = this.requestPath.getPathExpression().getParameterNames();
            queryParameters.removeAll(nonQueryParameters);
            this.pathRequestParameters = queryParameters;
        }
        return this.pathRequestParameters;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            this.saveCurrentJoin((HttpServletRequest)((HttpInboundServletRewrite)event).getRequest());
            if (this.chainingDisabled) {
                event.getRewriteContext().put((Object)JOIN_DISABLED_KEY, (Object)true);
                event.getRewriteContext().put((Object)(Join.class.getName() + "_DISABLED_RESET_NEXT"), (Object)false);
            }
            Forward.to(this.resourcePattern).perform(event, context);
        } else if (event instanceof HttpOutboundServletRewrite) {
            List<String> parameters = this.getPathRequestParameters();
            String outboundURL = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).toString();
            QueryStringBuilder query = QueryStringBuilder.createNew();
            if (outboundURL.contains("?")) {
                query.addParameters(outboundURL);
                for (String string : parameters) {
                    List values = query.removeParameter(string);
                    if (values.size() <= 1) continue;
                    query.addParameter(string, values.subList(1, values.size()).toArray(new String[0]));
                }
            }
            Substitute.with(this.requestPattern + query.toQueryString()).perform(event, context);
            if (this.chainingDisabled) {
                ((HttpOutboundServletRewrite)event).handled();
            }
        }
    }

    private void saveCurrentJoin(HttpServletRequest request) {
        request.setAttribute(CURRENT_JOIN, (Object)this);
    }

    public IJoin.JoinParameter where(String parameter) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        if (this.requestPath.getPathExpression().getParameterMap().containsKey(parameter)) {
            params.add(this.requestPath.where(parameter));
        }
        if (this.resourcePath.getPathExpression().getParameterMap().containsKey(parameter)) {
            params.add(this.resourcePath.where(parameter));
        }
        if (!params.isEmpty()) {
            return new IJoin.JoinParameter(this, params.toArray(new IPath.PathParameter[params.size()]));
        }
        throw new IllegalArgumentException("No such parameter [" + parameter + "] exists.");
    }

    public IJoin.JoinParameter where(String param, Binding binding) {
        return (IJoin.JoinParameter)this.where(param).bindsTo(binding);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public IJoin when(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public IJoin perform(Operation operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public IJoin withId(String id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "Join [url=" + this.requestPattern + ", to=" + this.resourcePattern + ", id=" + this.id + ", inboundCorrection=" + this.inboundCorrection + "]";
    }

    @Override
    public IJoin withChaining() {
        this.chainingDisabled = false;
        return this;
    }

    @Override
    public ParameterizedPatternParser getPathExpression() {
        return this.requestPath.getPathExpression();
    }

    @Override
    public ParameterizedPatternParser getResourcexpression() {
        return this.resourcePath.getPathExpression();
    }
}

