/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IHeader;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Header
extends HttpCondition
implements IHeader {
    private final ParameterizedPatternParser name;
    private final ParameterizedPatternParser value;
    private final ParameterStore<IHeader.HeaderParameter> parameters = new ParameterStore();

    private Header(String name, String value) {
        Assert.notNull((Object)name, (String)"Header name pattern cannot be null.");
        Assert.notNull((Object)value, (String)"Header value pattern cannot be null.");
        this.name = new RegexParameterizedPatternParser(name);
        this.value = new RegexParameterizedPatternParser(value);
    }

    public static Header matches(String name, String value) {
        return new Header(name, value);
    }

    public static Header exists(String name) {
        return new Header(name, "{" + Header.class.getName() + "_value}");
    }

    public static Header valueExists(String value) {
        return new Header("{" + Header.class.getName() + "_name}", value);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String header : Collections.list(request.getHeaderNames())) {
            if (!this.name.matches((Rewrite)event, context, header) || !this.matchesValue((Rewrite)event, context, request, header)) continue;
            Map parameterValues = this.name.parse((Rewrite)event, context, header);
            for (ParameterizedPatternParserParameter parameter : parameterValues.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)parameter, parameterValues.get(parameter))) continue;
                return false;
            }
            parameterValues = this.value.parse((Rewrite)event, context, header);
            for (ParameterizedPatternParserParameter parameter : parameterValues.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)parameter, parameterValues.get(parameter))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Collections.list(request.getHeaders(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }

    public IHeader.HeaderParameter where(String param) {
        ParameterizedPatternParserParameter nameParam = this.name.getParameterNames().contains(param) ? (ParameterizedPatternParserParameter)this.name.getParameter(param) : null;
        ParameterizedPatternParserParameter valueParam = this.value.getParameterNames().contains(param) ? (ParameterizedPatternParserParameter)this.value.getParameter(param) : null;
        return (IHeader.HeaderParameter)this.parameters.where(param, (ParameterBuilder)new IHeader.HeaderParameter(this, nameParam, valueParam));
    }
}

