/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IPath;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.urlbuilder.Address;

public class Path
extends HttpCondition
implements IPath {
    private final ParameterizedPatternParser expression;
    private final ParameterStore<IPath.PathParameter> parameters = new ParameterStore();
    private boolean withRequestBinding = false;

    private Path(String pattern) {
        Assert.notNull((Object)pattern, (String)"Path must not be null.");
        this.expression = new RegexParameterizedPatternParser("[^/]+", pattern);
        for (ParameterizedPatternParserParameter parameter : this.expression.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public static IPath matches(String pattern) {
        return new Path(pattern);
    }

    public static IPath captureIn(String param) {
        Path path = new Path("{" + param + "}");
        path.where(param).matches(".*");
        return path;
    }

    @Override
    public IPath withRequestBinding() {
        if (!this.withRequestBinding) {
            for (ParameterizedPatternParserParameter capture : this.expression.getParameterMap().values()) {
                this.where(capture.getName()).bindsTo((Binding)Request.parameter(capture.getName()));
            }
            this.withRequestBinding = true;
        }
        return this;
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String url = null;
        url = event instanceof HttpOutboundServletRewrite ? ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPath() : URLBuilder.createFrom((String)event.getInboundAddress().getPath()).decode().toPath();
        if (url.startsWith(event.getContextPath())) {
            url = url.substring(event.getContextPath().length());
        }
        if (this.expression.matches((Rewrite)event, context, url)) {
            Map parameters = this.expression.parse((Rewrite)event, context, url);
            for (ParameterizedPatternParserParameter capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ParameterizedPatternParser getPathExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public IPath.PathParameter where(String param) {
        return (IPath.PathParameter)this.parameters.where(param, (ParameterBuilder)new IPath.PathParameter(this, (ParameterizedPatternParserParameter)this.expression.getParameter(param)));
    }
}

