/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IURL;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;

public class URL
extends HttpCondition
implements IURL {
    private final ParameterizedPatternParser expression;
    private final ParameterStore<IURL.URLParameter> parameters = new ParameterStore();

    private URL(String pattern) {
        Assert.notNull((Object)pattern, (String)"URL must not be null.");
        this.expression = new RegexParameterizedPatternParser(".*", pattern);
        for (ParameterizedPatternParserParameter parameter : this.expression.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public static URL matches(String pattern) {
        return new URL(pattern);
    }

    public static URL captureIn(String param) {
        URL path = new URL("{" + param + "}");
        return path;
    }

    @Override
    public URL withRequestBinding() {
        for (ParameterizedPatternParserParameter capture : this.expression.getParameterMap().values()) {
            this.where(capture.getName()).bindsTo((Binding)Request.parameter(capture.getName()));
        }
        return this;
    }

    public IURL.URLParameter where(String param) {
        return (IURL.URLParameter)this.parameters.where(param, (ParameterBuilder)new IURL.URLParameter(this, (ParameterizedPatternParserParameter)this.expression.getParameter(param)));
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String requestURL = null;
        if (event instanceof HttpOutboundServletRewrite) {
            requestURL = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).toString();
            if (requestURL.startsWith(event.getContextPath())) {
                requestURL = requestURL.substring(event.getContextPath().length());
            }
        } else {
            requestURL = event.getAddress().toString();
        }
        if (this.expression.matches((Rewrite)event, context, requestURL)) {
            Map parameters = this.expression.parse((Rewrite)event, context, requestURL);
            for (ParameterizedPatternParserParameter capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ParameterizedPatternParser getSchemeExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public ParameterizedPatternParser getPathExpression() {
        return this.expression;
    }
}

