/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.HashSet;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexConstraint;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.urlbuilder.Address;

public class Path
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;
    private boolean withRequestBinding = false;
    private String captureIn;

    private Path(String pattern) {
        Assert.notNull((Object)pattern, (String)"Path must not be null.");
        this.expression = new RegexParameterizedPatternParser("[^/]+", pattern);
    }

    public static Path matches(String pattern) {
        return new Path(pattern);
    }

    public static Path captureIn(String param) {
        Path path = new Path("{" + param + "}");
        path.captureIn = param;
        return path;
    }

    public Path withRequestBinding() {
        this.withRequestBinding = true;
        return this;
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String url = null;
        url = event instanceof HttpOutboundServletRewrite ? ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPath() : URLBuilder.createFrom((String)event.getInboundAddress().getPath()).decode().toPath();
        if (url.startsWith(event.getContextPath())) {
            url = url.substring(event.getContextPath().length());
        }
        return this.expression.matches((Rewrite)event, context, url);
    }

    public ParameterizedPatternParser getPathExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.captureIn != null) {
            result.add(this.captureIn);
        } else {
            result.addAll(this.expression.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.captureIn != null) {
            store.get(this.captureIn).constrainedBy((Constraint)new RegexConstraint(".*"));
        }
        if (this.withRequestBinding) {
            for (String param : this.getRequiredParameterNames()) {
                store.get(param).bindsTo((Binding)Request.parameter(param));
            }
            this.withRequestBinding = true;
        }
        this.expression.setParameterStore(store);
    }
}

