/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Header
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser name;
    private final ParameterizedPatternParser value;

    private Header(String name, String value) {
        Assert.notNull((Object)name, (String)"Header name pattern cannot be null.");
        Assert.notNull((Object)value, (String)"Header value pattern cannot be null.");
        this.name = new RegexParameterizedPatternParser(name);
        this.value = new RegexParameterizedPatternParser(value);
    }

    public static Header matches(String name, String value) {
        return new Header(name, value);
    }

    public static Header exists(String name) {
        return new Header(name, "{" + Header.class.getName() + "_value}");
    }

    public static Header valueExists(String value) {
        return new Header("{" + Header.class.getName() + "_name}", value);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            for (String header : Collections.list(headerNames)) {
                if (!this.name.matches((Rewrite)event, context, header) || !this.matchesValue((Rewrite)event, context, request, header)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        Enumeration headers = request.getHeaders(header);
        if (headers != null) {
            for (String contents : Collections.list(headers)) {
                if (!this.value.matches(event, context, contents)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.name.getRequiredParameterNames());
        result.addAll(this.value.getRequiredParameterNames());
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.name.setParameterStore(store);
        this.value.setParameterStore(store);
    }
}

