/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.ParseTools;
import org.ocpsoft.rewrite.util.Transpositions;

public class Forward
extends HttpOperation
implements Parameterized {
    private final ParameterizedPatternBuilder location;

    private Forward(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null.");
        this.location = new RegexParameterizedPatternBuilder(ParseTools.CaptureType.BRACE, "[^/]+", location);
    }

    public static Forward to(String location) {
        return new Forward(location);
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build((Rewrite)event, context, Transpositions.identity());
            ((HttpInboundServletRewrite)event).forward(target);
        }
    }

    public String toString() {
        return this.location.toString();
    }

    public ParameterizedPatternBuilder getTargetExpression() {
        return this.location;
    }

    public Set<String> getRequiredParameterNames() {
        return this.location.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.location.setParameterStore(store);
    }
}

