/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.servlet.ServletRegistration;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.Resource;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.spi.ServletRegistrationProvider;
import org.ocpsoft.rewrite.util.Transpositions;

public class ServletMapping
extends HttpCondition
implements Parameterized {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final RegexParameterizedPatternBuilder resource;
    private List<ServletRegistrationProvider> servletRegistrationProviders = null;

    private ServletMapping(String resource) {
        this.resource = new RegexParameterizedPatternBuilder(resource);
    }

    public static ServletMapping includes(String resource) {
        return new ServletMapping(resource);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null && this.resource.isParameterComplete((Rewrite)event, context)) {
            String path = this.resource.build((Rewrite)event, context, Transpositions.encodePath());
            try {
                for (ServletRegistration registration : this.getServletRegistration(event.getServletContext())) {
                    List mappings = registration.getMappings();
                    for (String mapping : mappings) {
                        if (path.startsWith("/") && !mapping.startsWith("/")) {
                            mapping = "/" + mapping;
                        }
                        if (mapping.contains("*")) {
                            mapping = mapping.replaceAll("\\*", ".*");
                        }
                        if (!path.matches(mapping)) continue;
                        return true;
                    }
                }
                return event.getServletContext().getResource(path) != null;
            }
            catch (MalformedURLException e) {
                log.debug("Invalid file format [{}]", (Object)path);
            }
        }
        return false;
    }

    private List<ServletRegistration> getServletRegistration(ServletContext context) {
        for (ServletRegistrationProvider provider : this.getServletRegistrationProviders()) {
            List registrations = provider.getServletRegistrations(context);
            if (registrations == null) continue;
            return registrations;
        }
        throw new IllegalStateException("Unable to find the Servlet registrations of the application");
    }

    private List<ServletRegistrationProvider> getServletRegistrationProviders() {
        if (this.servletRegistrationProviders == null) {
            this.servletRegistrationProviders = Iterators.asList((Iterator)ServiceLoader.loadTypesafe(ServletRegistrationProvider.class).iterator());
            Collections.sort(this.servletRegistrationProviders, new WeightedComparator());
        }
        return this.servletRegistrationProviders;
    }

    public ParameterizedPatternBuilder getResourceExpression() {
        return this.resource;
    }

    public Set<String> getRequiredParameterNames() {
        return this.resource.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.resource.setParameterStore(store);
    }
}

